package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CA证书信息
 */
@ApiModel(description = "CA证书信息")

@JsonInclude(NON_NULL)
public class CAInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("machineNo")
  private String machineNo = null;

  @JsonProperty("companyCA")
  private String companyCA = null;

  @JsonProperty("publisherCA")
  private String publisherCA = null;

  @JsonProperty("mi")
  private String mi = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public CAInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public CAInfo machineNo(String machineNo) {
    this.machineNo = machineNo;
    return this;
  }

   /**
   * 开票机号
   * @return machineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineNo() {
    return machineNo;
  }

  public void setMachineNo(String machineNo) {
    this.machineNo = machineNo;
  }

  @JsonIgnore
  public CAInfo companyCA(String companyCA) {
    this.companyCA = companyCA;
    return this;
  }

   /**
   * 企业证书
   * @return companyCA
  **/


  @ApiModelProperty(value = "企业证书")
  public String getCompanyCA() {
    return companyCA;
  }

  public void setCompanyCA(String companyCA) {
    this.companyCA = companyCA;
  }

  @JsonIgnore
  public CAInfo publisherCA(String publisherCA) {
    this.publisherCA = publisherCA;
    return this;
  }

   /**
   * 发布者证书
   * @return publisherCA
  **/


  @ApiModelProperty(value = "发布者证书")
  public String getPublisherCA() {
    return publisherCA;
  }

  public void setPublisherCA(String publisherCA) {
    this.publisherCA = publisherCA;
  }

  @JsonIgnore
  public CAInfo mi(String mi) {
    this.mi = mi;
    return this;
  }

   /**
   * mi
   * @return mi
  **/


  @ApiModelProperty(value = "mi")
  public String getMi() {
    return mi;
  }

  public void setMi(String mi) {
    this.mi = mi;
  }

  @JsonIgnore
  public CAInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CAInfo caInfo = (CAInfo) o;
    return Objects.equals(this.taxNo, caInfo.taxNo) &&
        Objects.equals(this.machineNo, caInfo.machineNo) &&
        Objects.equals(this.companyCA, caInfo.companyCA) &&
        Objects.equals(this.publisherCA, caInfo.publisherCA) &&
        Objects.equals(this.mi, caInfo.mi) &&
        Objects.equals(this.operateInfo, caInfo.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNo, machineNo, companyCA, publisherCA, mi, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CAInfo {\n");
    
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    machineNo: ").append(toIndentedString(machineNo)).append("\n");
    sb.append("    companyCA: ").append(toIndentedString(companyCA)).append("\n");
    sb.append("    publisherCA: ").append(toIndentedString(publisherCA)).append("\n");
    sb.append("    mi: ").append(toIndentedString(mi)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
