package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CancelExtractRequest
 */

@JsonInclude(NON_NULL)
public class CancelExtractRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("extractType")
  private Integer extractType = null;

  @JsonProperty("extractValue")
  private String extractValue = null;

  @JsonIgnore
  public CancelExtractRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public CancelExtractRequest extractType(Integer extractType) {
    this.extractType = extractType;
    return this;
  }

   /**
   * 抽取类型：1【抵账】2【税盘】
   * @return extractType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "抽取类型：1【抵账】2【税盘】")
  public Integer getExtractType() {
    return extractType;
  }

  public void setExtractType(Integer extractType) {
    this.extractType = extractType;
  }

  @JsonIgnore
  public CancelExtractRequest extractValue(String extractValue) {
    this.extractValue = extractValue;
    return this;
  }

   /**
   * 类型值：抵账传税号，税盘传设备ID
   * @return extractValue
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "类型值：抵账传税号，税盘传设备ID")
  public String getExtractValue() {
    return extractValue;
  }

  public void setExtractValue(String extractValue) {
    this.extractValue = extractValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancelExtractRequest cancelExtractRequest = (CancelExtractRequest) o;
    return Objects.equals(this.head, cancelExtractRequest.head) &&
        Objects.equals(this.extractType, cancelExtractRequest.extractType) &&
        Objects.equals(this.extractValue, cancelExtractRequest.extractValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, extractType, extractValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancelExtractRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    extractType: ").append(toIndentedString(extractType)).append("\n");
    sb.append("    extractValue: ").append(toIndentedString(extractValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
