package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ClientUpdateResponse
 */

@JsonInclude(NON_NULL)
public class ClientUpdateResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("url")
  private String url = null;

  @JsonIgnore
  public ClientUpdateResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 公共头部响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "公共头部响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ClientUpdateResponse url(String url) {
    this.url = url;
    return this;
  }

   /**
   * 下载链接
   * @return url
  **/


  @ApiModelProperty(value = "下载链接")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientUpdateResponse clientUpdateResponse = (ClientUpdateResponse) o;
    return Objects.equals(this.head, clientUpdateResponse.head) &&
        Objects.equals(this.url, clientUpdateResponse.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, url);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientUpdateResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
