package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * DeviceCAQueryRequest
 */

@JsonInclude(NON_NULL)
public class DeviceCAQueryRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("acquireType")
  private String acquireType = null;

  @JsonProperty("mi")
  private String mi = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("machineNo")
  private String machineNo = null;

  @JsonIgnore
  public DeviceCAQueryRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public DeviceCAQueryRequest acquireType(String acquireType) {
    this.acquireType = acquireType;
    return this;
  }

   /**
   * 请求类型，1：根据税号和开票机号 2：根据mi号
   * @return acquireType
  **/


  @ApiModelProperty(value = "请求类型，1：根据税号和开票机号 2：根据mi号")
  public String getAcquireType() {
    return acquireType;
  }

  public void setAcquireType(String acquireType) {
    this.acquireType = acquireType;
  }

  @JsonIgnore
  public DeviceCAQueryRequest mi(String mi) {
    this.mi = mi;
    return this;
  }

   /**
   * mi号
   * @return mi
  **/


  @ApiModelProperty(value = "mi号")
  public String getMi() {
    return mi;
  }

  public void setMi(String mi) {
    this.mi = mi;
  }

  @JsonIgnore
  public DeviceCAQueryRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public DeviceCAQueryRequest machineNo(String machineNo) {
    this.machineNo = machineNo;
    return this;
  }

   /**
   * 开票机号
   * @return machineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineNo() {
    return machineNo;
  }

  public void setMachineNo(String machineNo) {
    this.machineNo = machineNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceCAQueryRequest deviceCAQueryRequest = (DeviceCAQueryRequest) o;
    return Objects.equals(this.head, deviceCAQueryRequest.head) &&
        Objects.equals(this.acquireType, deviceCAQueryRequest.acquireType) &&
        Objects.equals(this.mi, deviceCAQueryRequest.mi) &&
        Objects.equals(this.taxNo, deviceCAQueryRequest.taxNo) &&
        Objects.equals(this.machineNo, deviceCAQueryRequest.machineNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, acquireType, mi, taxNo, machineNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceCAQueryRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    acquireType: ").append(toIndentedString(acquireType)).append("\n");
    sb.append("    mi: ").append(toIndentedString(mi)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    machineNo: ").append(toIndentedString(machineNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
