package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 客户端信息
 */
@ApiModel(description = "客户端信息")

@JsonInclude(NON_NULL)
public class HeartBeatClientInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("version")
  private String version = null;

  @JsonIgnore
  public HeartBeatClientInfo version(String version) {
    this.version = version;
    return this;
  }

   /**
   * 客户端版本
   * @return version
  **/


  @ApiModelProperty(value = "客户端版本")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HeartBeatClientInfo heartBeatClientInfo = (HeartBeatClientInfo) o;
    return Objects.equals(this.version, heartBeatClientInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HeartBeatClientInfo {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
