package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceDeposeRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceDeposeRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invalidName")
  private String invalidName = null;

  @JsonIgnore
  public InvoiceDeposeRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceDeposeRequest terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public InvoiceDeposeRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id（客户端：必填,客户端空白发票作废，只能作废当前卷的第一张发票）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id（客户端：必填,客户端空白发票作废，只能作废当前卷的第一张发票）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public InvoiceDeposeRequest requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public InvoiceDeposeRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型（客户端支持【c、s、v】服务器端支持【c、s】c：普通空白发票作废、s:专票空白发票作废、v:机动车空白发票作废）
   * @return invoiceType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票类型（客户端支持【c、s、v】服务器端支持【c、s】c：普通空白发票作废、s:专票空白发票作废、v:机动车空白发票作废）")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public InvoiceDeposeRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceDeposeRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoiceDeposeRequest invalidName(String invalidName) {
    this.invalidName = invalidName;
    return this;
  }

   /**
   * 作废人姓名
   * @return invalidName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "作废人姓名")
  public String getInvalidName() {
    return invalidName;
  }

  public void setInvalidName(String invalidName) {
    this.invalidName = invalidName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDeposeRequest invoiceDeposeRequest = (InvoiceDeposeRequest) o;
    return Objects.equals(this.head, invoiceDeposeRequest.head) &&
        Objects.equals(this.terminalId, invoiceDeposeRequest.terminalId) &&
        Objects.equals(this.deviceId, invoiceDeposeRequest.deviceId) &&
        Objects.equals(this.requestSerialNo, invoiceDeposeRequest.requestSerialNo) &&
        Objects.equals(this.invoiceType, invoiceDeposeRequest.invoiceType) &&
        Objects.equals(this.invoiceCode, invoiceDeposeRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceDeposeRequest.invoiceNo) &&
        Objects.equals(this.invalidName, invoiceDeposeRequest.invalidName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalId, deviceId, requestSerialNo, invoiceType, invoiceCode, invoiceNo, invalidName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDeposeRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invalidName: ").append(toIndentedString(invalidName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
