package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceDeposeResponse
 */

@JsonInclude(NON_NULL)
public class InvoiceDeposeResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonIgnore
  public InvoiceDeposeResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceDeposeResponse requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDeposeResponse invoiceDeposeResponse = (InvoiceDeposeResponse) o;
    return Objects.equals(this.head, invoiceDeposeResponse.head) &&
        Objects.equals(this.requestSerialNo, invoiceDeposeResponse.requestSerialNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDeposeResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
