package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDispatcherResultInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceDispatcherResultRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceDispatcherResultRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceInfo")
  private InvoiceDispatcherResultInfo deviceInfo = null;

  @JsonIgnore
  public InvoiceDispatcherResultRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceDispatcherResultRequest deviceInfo(InvoiceDispatcherResultInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * 发票分发结果信息
   * @return deviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "发票分发结果信息")
  public InvoiceDispatcherResultInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(InvoiceDispatcherResultInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDispatcherResultRequest invoiceDispatcherResultRequest = (InvoiceDispatcherResultRequest) o;
    return Objects.equals(this.head, invoiceDispatcherResultRequest.head) &&
        Objects.equals(this.deviceInfo, invoiceDispatcherResultRequest.deviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDispatcherResultRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
