package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class OperateInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("createdBy")
  private String createdBy = null;

  @JsonProperty("createdAt")
  private String createdAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("updatedAt")
  private String updatedAt = null;

  @JsonIgnore
  public OperateInfo createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 创建人ID,新增数据时传入
   * @return createdBy
  **/


  @ApiModelProperty(value = "创建人ID,新增数据时传入")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  @JsonIgnore
  public OperateInfo createdAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * 创建时间 yyyyMMddHHmmss
   * @return createdAt
  **/


  @ApiModelProperty(value = "创建时间 yyyyMMddHHmmss")
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }

  @JsonIgnore
  public OperateInfo updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * 更新人ID，更新数据时传入
   * @return updatedBy
  **/


  @ApiModelProperty(value = "更新人ID，更新数据时传入")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  @JsonIgnore
  public OperateInfo updatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * 更新时间 yyyyMMddHHmmss
   * @return updatedAt
  **/


  @ApiModelProperty(value = "更新时间 yyyyMMddHHmmss")
  public String getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperateInfo operateInfo = (OperateInfo) o;
    return Objects.equals(this.createdBy, operateInfo.createdBy) &&
        Objects.equals(this.createdAt, operateInfo.createdAt) &&
        Objects.equals(this.updatedBy, operateInfo.updatedBy) &&
        Objects.equals(this.updatedAt, operateInfo.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdBy, createdAt, updatedBy, updatedAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperateInfo {\n");
    
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
