package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryConfigInfoRequest
 */

@JsonInclude(NON_NULL)
public class QueryConfigInfoRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("configType")
  private Integer configType = 5;

  @JsonProperty("configId")
  private String configId = null;

  @JsonProperty("prefix")
  private String prefix = null;

  @JsonIgnore
  public QueryConfigInfoRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryConfigInfoRequest configType(Integer configType) {
    this.configType = configType;
    return this;
  }

   /**
   * 0:获取全局配置，1:根据设备ID获取配置,2:根据终端ID获取配置，3:根据租户ID获取配置，4:根据税号获取配置，5:根据授权文件编号获取配置(默认值)
   * @return configType
  **/


  @ApiModelProperty(value = "0:获取全局配置，1:根据设备ID获取配置,2:根据终端ID获取配置，3:根据租户ID获取配置，4:根据税号获取配置，5:根据授权文件编号获取配置(默认值)")
  public Integer getConfigType() {
    return configType;
  }

  public void setConfigType(Integer configType) {
    this.configType = configType;
  }

  @JsonIgnore
  public QueryConfigInfoRequest configId(String configId) {
    this.configId = configId;
    return this;
  }

   /**
   * 类型值
   * @return configId
  **/


  @ApiModelProperty(value = "类型值")
  public String getConfigId() {
    return configId;
  }

  public void setConfigId(String configId) {
    this.configId = configId;
  }

  @JsonIgnore
  public QueryConfigInfoRequest prefix(String prefix) {
    this.prefix = prefix;
    return this;
  }

   /**
   * 根据前缀匹配Key
   * @return prefix
  **/


  @ApiModelProperty(value = "根据前缀匹配Key")
  public String getPrefix() {
    return prefix;
  }

  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryConfigInfoRequest queryConfigInfoRequest = (QueryConfigInfoRequest) o;
    return Objects.equals(this.head, queryConfigInfoRequest.head) &&
        Objects.equals(this.configType, queryConfigInfoRequest.configType) &&
        Objects.equals(this.configId, queryConfigInfoRequest.configId) &&
        Objects.equals(this.prefix, queryConfigInfoRequest.prefix);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, configType, configId, prefix);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryConfigInfoRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    configType: ").append(toIndentedString(configType)).append("\n");
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
