package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.HeartBeatClientInfo;
import com.xforceplus.micro.tax.device.contract.model.HeartBeatDetail;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryQueueStatusResponse1
 */

@JsonInclude(NON_NULL)
public class QueryQueueStatusResponse1 implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("directOnlineFlag")
  private Boolean directOnlineFlag = false;

  @JsonProperty("amqDirectOnlineFlag")
  private Boolean amqDirectOnlineFlag = false;

  @JsonProperty("sqsDrawOnlineFlag")
  private Boolean sqsDrawOnlineFlag = false;

  @JsonProperty("sqsOriginAccountOnlineFlag")
  private Boolean sqsOriginAccountOnlineFlag = false;

  @JsonProperty("trusteeshipFlag")
  private Boolean trusteeshipFlag = null;

  @JsonProperty("amqQueueOnlineFlag")
  private Boolean amqQueueOnlineFlag = null;

  @JsonProperty("clientInfo")
  private HeartBeatClientInfo clientInfo = null;

  @JsonProperty("heartBeatDetail")
  private HeartBeatDetail heartBeatDetail = null;

  @JsonProperty("sourceFrom")
  private String sourceFrom = null;

  @JsonIgnore
  public QueryQueueStatusResponse1 head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询队列状态响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询队列状态响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * SQS队列名称
   * @return queueName
  **/


  @ApiModelProperty(value = "SQS队列名称")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 directOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
    return this;
  }

   /**
   * SQS直连在线标志,true:在线 false:不在线
   * @return directOnlineFlag
  **/


  @ApiModelProperty(value = "SQS直连在线标志,true:在线 false:不在线")
  public Boolean DirectOnlineFlag() {
    return directOnlineFlag;
  }

  public void setDirectOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 amqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
    return this;
  }

   /**
   * 【基于心跳】amq直连在线标志,true:在线 false:不在线
   * @return amqDirectOnlineFlag
  **/


  @ApiModelProperty(value = "【基于心跳】amq直连在线标志,true:在线 false:不在线")
  public Boolean AmqDirectOnlineFlag() {
    return amqDirectOnlineFlag;
  }

  public void setAmqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sqsDrawOnlineFlag(Boolean sqsDrawOnlineFlag) {
    this.sqsDrawOnlineFlag = sqsDrawOnlineFlag;
    return this;
  }

   /**
   * SQS抽取在线标志,true:在线 false:不在线
   * @return sqsDrawOnlineFlag
  **/


  @ApiModelProperty(value = "SQS抽取在线标志,true:在线 false:不在线")
  public Boolean SqsDrawOnlineFlag() {
    return sqsDrawOnlineFlag;
  }

  public void setSqsDrawOnlineFlag(Boolean sqsDrawOnlineFlag) {
    this.sqsDrawOnlineFlag = sqsDrawOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sqsOriginAccountOnlineFlag(Boolean sqsOriginAccountOnlineFlag) {
    this.sqsOriginAccountOnlineFlag = sqsOriginAccountOnlineFlag;
    return this;
  }

   /**
   * SQS抵账在线标志,true:在线 false:不在线
   * @return sqsOriginAccountOnlineFlag
  **/


  @ApiModelProperty(value = "SQS抵账在线标志,true:在线 false:不在线")
  public Boolean SqsOriginAccountOnlineFlag() {
    return sqsOriginAccountOnlineFlag;
  }

  public void setSqsOriginAccountOnlineFlag(Boolean sqsOriginAccountOnlineFlag) {
    this.sqsOriginAccountOnlineFlag = sqsOriginAccountOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 trusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
    return this;
  }

   /**
   * 托管标志,true：托管 false：非托管
   * @return trusteeshipFlag
  **/


  @ApiModelProperty(value = "托管标志,true：托管 false：非托管")
  public Boolean TrusteeshipFlag() {
    return trusteeshipFlag;
  }

  public void setTrusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 amqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
    return this;
  }

   /**
   * MI对应的队列在线标志,true：在线 false：不在线，参数中传入：acquireQueueStatusInAMQ=true时返回
   * @return amqQueueOnlineFlag
  **/


  @ApiModelProperty(value = "MI对应的队列在线标志,true：在线 false：不在线，参数中传入：acquireQueueStatusInAMQ=true时返回")
  public Boolean AmqQueueOnlineFlag() {
    return amqQueueOnlineFlag;
  }

  public void setAmqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 clientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * 客户端信息
   * @return clientInfo
  **/

  @Valid

  @ApiModelProperty(value = "客户端信息")
  public HeartBeatClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 heartBeatDetail(HeartBeatDetail heartBeatDetail) {
    this.heartBeatDetail = heartBeatDetail;
    return this;
  }

   /**
   * 心跳数据详细信息，仅当数据来源为正常心跳时返回
   * @return heartBeatDetail
  **/

  @Valid

  @ApiModelProperty(value = "心跳数据详细信息，仅当数据来源为正常心跳时返回")
  public HeartBeatDetail getHeartBeatDetail() {
    return heartBeatDetail;
  }

  public void setHeartBeatDetail(HeartBeatDetail heartBeatDetail) {
    this.heartBeatDetail = heartBeatDetail;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sourceFrom(String sourceFrom) {
    this.sourceFrom = sourceFrom;
    return this;
  }

   /**
   * 数据来源，heartBeat-normal:正常的心跳，heartBeat-expired:过期心跳，none:无
   * @return sourceFrom
  **/


  @ApiModelProperty(value = "数据来源，heartBeat-normal:正常的心跳，heartBeat-expired:过期心跳，none:无")
  public String getSourceFrom() {
    return sourceFrom;
  }

  public void setSourceFrom(String sourceFrom) {
    this.sourceFrom = sourceFrom;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryQueueStatusResponse1 queryQueueStatusResponse1 = (QueryQueueStatusResponse1) o;
    return Objects.equals(this.head, queryQueueStatusResponse1.head) &&
        Objects.equals(this.queueName, queryQueueStatusResponse1.queueName) &&
        Objects.equals(this.directOnlineFlag, queryQueueStatusResponse1.directOnlineFlag) &&
        Objects.equals(this.amqDirectOnlineFlag, queryQueueStatusResponse1.amqDirectOnlineFlag) &&
        Objects.equals(this.sqsDrawOnlineFlag, queryQueueStatusResponse1.sqsDrawOnlineFlag) &&
        Objects.equals(this.sqsOriginAccountOnlineFlag, queryQueueStatusResponse1.sqsOriginAccountOnlineFlag) &&
        Objects.equals(this.trusteeshipFlag, queryQueueStatusResponse1.trusteeshipFlag) &&
        Objects.equals(this.amqQueueOnlineFlag, queryQueueStatusResponse1.amqQueueOnlineFlag) &&
        Objects.equals(this.clientInfo, queryQueueStatusResponse1.clientInfo) &&
        Objects.equals(this.heartBeatDetail, queryQueueStatusResponse1.heartBeatDetail) &&
        Objects.equals(this.sourceFrom, queryQueueStatusResponse1.sourceFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queueName, directOnlineFlag, amqDirectOnlineFlag, sqsDrawOnlineFlag, sqsOriginAccountOnlineFlag, trusteeshipFlag, amqQueueOnlineFlag, clientInfo, heartBeatDetail, sourceFrom);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryQueueStatusResponse1 {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
    sb.append("    amqDirectOnlineFlag: ").append(toIndentedString(amqDirectOnlineFlag)).append("\n");
    sb.append("    sqsDrawOnlineFlag: ").append(toIndentedString(sqsDrawOnlineFlag)).append("\n");
    sb.append("    sqsOriginAccountOnlineFlag: ").append(toIndentedString(sqsOriginAccountOnlineFlag)).append("\n");
    sb.append("    trusteeshipFlag: ").append(toIndentedString(trusteeshipFlag)).append("\n");
    sb.append("    amqQueueOnlineFlag: ").append(toIndentedString(amqQueueOnlineFlag)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    heartBeatDetail: ").append(toIndentedString(heartBeatDetail)).append("\n");
    sb.append("    sourceFrom: ").append(toIndentedString(sourceFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
