package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QuerySqsStatusResponseQueueStatus
 */

@JsonInclude(NON_NULL)
public class QuerySqsStatusResponseQueueStatus implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("account")
  private String account = null;

  @JsonProperty("directOnlineFlag")
  private Boolean directOnlineFlag = null;

  @JsonIgnore
  public QuerySqsStatusResponseQueueStatus account(String account) {
    this.account = account;
    return this;
  }

   /**
   * 账号
   * @return account
  **/


  @ApiModelProperty(value = "账号")
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  @JsonIgnore
  public QuerySqsStatusResponseQueueStatus directOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
    return this;
  }

   /**
   * SQS直连在线标志,true:在线 false:不在线
   * @return directOnlineFlag
  **/


  @ApiModelProperty(value = "SQS直连在线标志,true:在线 false:不在线")
  public Boolean DirectOnlineFlag() {
    return directOnlineFlag;
  }

  public void setDirectOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuerySqsStatusResponseQueueStatus querySqsStatusResponseQueueStatus = (QuerySqsStatusResponseQueueStatus) o;
    return Objects.equals(this.account, querySqsStatusResponseQueueStatus.account) &&
        Objects.equals(this.directOnlineFlag, querySqsStatusResponseQueueStatus.directOnlineFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(account, directOnlineFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuerySqsStatusResponseQueueStatus {\n");
    
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
