package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 抽取订阅信息
 */
@ApiModel(description = "抽取订阅信息")

@JsonInclude(NON_NULL)
public class SubscribeExtractInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("extractType")
  private Integer extractType = null;

  @JsonProperty("extractValue")
  private String extractValue = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("subscribeType")
  private Integer subscribeType = null;

  @JsonProperty("subscribeValue")
  private String subscribeValue = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonIgnore
  public SubscribeExtractInfo extractType(Integer extractType) {
    this.extractType = extractType;
    return this;
  }

   /**
   * 抽取类型：1【抵账】2【税盘】
   * @return extractType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "抽取类型：1【抵账】2【税盘】")
  public Integer getExtractType() {
    return extractType;
  }

  public void setExtractType(Integer extractType) {
    this.extractType = extractType;
  }

  @JsonIgnore
  public SubscribeExtractInfo extractValue(String extractValue) {
    this.extractValue = extractValue;
    return this;
  }

   /**
   * 类型值：抵账传税号，税盘传设备ID
   * @return extractValue
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "类型值：抵账传税号，税盘传设备ID")
  public String getExtractValue() {
    return extractValue;
  }

  public void setExtractValue(String extractValue) {
    this.extractValue = extractValue;
  }

  @JsonIgnore
  public SubscribeExtractInfo description(String description) {
    this.description = description;
    return this;
  }

   /**
   * 描述
   * @return description
  **/


  @ApiModelProperty(value = "描述")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @JsonIgnore
  public SubscribeExtractInfo subscribeType(Integer subscribeType) {
    this.subscribeType = subscribeType;
    return this;
  }

   /**
   * 订阅类型：1【SQS】
   * @return subscribeType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "订阅类型：1【SQS】")
  public Integer getSubscribeType() {
    return subscribeType;
  }

  public void setSubscribeType(Integer subscribeType) {
    this.subscribeType = subscribeType;
  }

  @JsonIgnore
  public SubscribeExtractInfo subscribeValue(String subscribeValue) {
    this.subscribeValue = subscribeValue;
    return this;
  }

   /**
   * 订阅地址：订阅类型为1时【SQS队列名】
   * @return subscribeValue
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "订阅地址：订阅类型为1时【SQS队列名】")
  public String getSubscribeValue() {
    return subscribeValue;
  }

  public void setSubscribeValue(String subscribeValue) {
    this.subscribeValue = subscribeValue;
  }

  @JsonIgnore
  public SubscribeExtractInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeExtractInfo subscribeExtractInfo = (SubscribeExtractInfo) o;
    return Objects.equals(this.extractType, subscribeExtractInfo.extractType) &&
        Objects.equals(this.extractValue, subscribeExtractInfo.extractValue) &&
        Objects.equals(this.description, subscribeExtractInfo.description) &&
        Objects.equals(this.subscribeType, subscribeExtractInfo.subscribeType) &&
        Objects.equals(this.subscribeValue, subscribeExtractInfo.subscribeValue) &&
        Objects.equals(this.fromSystem, subscribeExtractInfo.fromSystem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(extractType, extractValue, description, subscribeType, subscribeValue, fromSystem);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeExtractInfo {\n");
    
    sb.append("    extractType: ").append(toIndentedString(extractType)).append("\n");
    sb.append("    extractValue: ").append(toIndentedString(extractValue)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    subscribeType: ").append(toIndentedString(subscribeType)).append("\n");
    sb.append("    subscribeValue: ").append(toIndentedString(subscribeValue)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
