package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * TerminalBindClientResponseQueryClientInfo
 */

@JsonInclude(NON_NULL)
public class TerminalBindClientResponseQueryClientInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("unionId")
  private String unionId = null;

  @JsonProperty("cid")
  private String cid = null;

  @JsonProperty("hostName")
  private String hostName = null;

  @JsonIgnore
  public TerminalBindClientResponseQueryClientInfo unionId(String unionId) {
    this.unionId = unionId;
    return this;
  }

   /**
   * 终端unionId
   * @return unionId
  **/


  @ApiModelProperty(value = "终端unionId")
  public String getUnionId() {
    return unionId;
  }

  public void setUnionId(String unionId) {
    this.unionId = unionId;
  }

  @JsonIgnore
  public TerminalBindClientResponseQueryClientInfo cid(String cid) {
    this.cid = cid;
    return this;
  }

   /**
   * 客户端CID
   * @return cid
  **/


  @ApiModelProperty(value = "客户端CID")
  public String getCid() {
    return cid;
  }

  public void setCid(String cid) {
    this.cid = cid;
  }

  @JsonIgnore
  public TerminalBindClientResponseQueryClientInfo hostName(String hostName) {
    this.hostName = hostName;
    return this;
  }

   /**
   * 主机名
   * @return hostName
  **/


  @ApiModelProperty(value = "主机名")
  public String getHostName() {
    return hostName;
  }

  public void setHostName(String hostName) {
    this.hostName = hostName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalBindClientResponseQueryClientInfo terminalBindClientResponseQueryClientInfo = (TerminalBindClientResponseQueryClientInfo) o;
    return Objects.equals(this.unionId, terminalBindClientResponseQueryClientInfo.unionId) &&
        Objects.equals(this.cid, terminalBindClientResponseQueryClientInfo.cid) &&
        Objects.equals(this.hostName, terminalBindClientResponseQueryClientInfo.hostName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(unionId, cid, hostName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalBindClientResponseQueryClientInfo {\n");
    
    sb.append("    unionId: ").append(toIndentedString(unionId)).append("\n");
    sb.append("    cid: ").append(toIndentedString(cid)).append("\n");
    sb.append("    hostName: ").append(toIndentedString(hostName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
