package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.OriginAccountTerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class TerminalInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("companyInfo")
  private CompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<>();

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("paddingLeft")
  private Integer paddingLeft = null;

  @JsonProperty("paddingTop")
  private Integer paddingTop = null;

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSaleListTerminalId")
  private Long printSaleListTerminalId = null;

  @JsonProperty("uKeySupportFlag")
  private Integer uKeySupportFlag = null;

  @JsonProperty("customExtra")
  private String customExtra = null;

  @JsonProperty("originAccountInfo")
  private OriginAccountTerminalInfo originAccountInfo = null;

  @JsonIgnore
  public TerminalInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 终端id
   * @return id
  **/


  @ApiModelProperty(value = "终端id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public TerminalInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id，服务器终端时传入
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id，服务器终端时传入")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public TerminalInfo companyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息")
  public CompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public TerminalInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public TerminalInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/


  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public TerminalInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/


  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public TerminalInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器 3:底账服务器 4:区块链终端
   * @return terminalType
  **/


  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器 3:底账服务器 4:区块链终端")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public TerminalInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public TerminalInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public TerminalInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public TerminalInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账，assistant：辅助）
   * @return supportService
  **/


  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账，assistant：辅助）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public TerminalInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）
   * @return status
  **/


  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public TerminalInfo paddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
    return this;
  }

   /**
   * 左边距
   * @return paddingLeft
  **/


  @ApiModelProperty(value = "左边距")
  public Integer getPaddingLeft() {
    return paddingLeft;
  }

  public void setPaddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
  }

  @JsonIgnore
  public TerminalInfo paddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
    return this;
  }

   /**
   * 上边距
   * @return paddingTop
  **/


  @ApiModelProperty(value = "上边距")
  public Integer getPaddingTop() {
    return paddingTop;
  }

  public void setPaddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
  }

  @JsonIgnore
  public TerminalInfo printInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
    return this;
  }

   /**
   * 打印发票终端id
   * @return printInvoiceTerminalId
  **/


  @ApiModelProperty(value = "打印发票终端id")
  public Long getPrintInvoiceTerminalId() {
    return printInvoiceTerminalId;
  }

  public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
  }

  @JsonIgnore
  public TerminalInfo printSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
    return this;
  }

   /**
   * 打印销货清单终端id
   * @return printSaleListTerminalId
  **/


  @ApiModelProperty(value = "打印销货清单终端id")
  public Long getPrintSaleListTerminalId() {
    return printSaleListTerminalId;
  }

  public void setPrintSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
  }

  @JsonIgnore
  public TerminalInfo uKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
    return this;
  }

   /**
   * ukey支持标志，0-不支持 1-支持
   * @return uKeySupportFlag
  **/


  @ApiModelProperty(value = "ukey支持标志，0-不支持 1-支持")
  public Integer getUKeySupportFlag() {
    return uKeySupportFlag;
  }

  public void setUKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
  }

  @JsonIgnore
  public TerminalInfo customExtra(String customExtra) {
    this.customExtra = customExtra;
    return this;
  }

   /**
   * 自定义额外参数
   * @return customExtra
  **/


  @ApiModelProperty(value = "自定义额外参数")
  public String getCustomExtra() {
    return customExtra;
  }

  public void setCustomExtra(String customExtra) {
    this.customExtra = customExtra;
  }

  @JsonIgnore
  public TerminalInfo originAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
    return this;
  }

   /**
   * 底账服务器终端信息
   * @return originAccountInfo
  **/

  @Valid

  @ApiModelProperty(value = "底账服务器终端信息")
  public OriginAccountTerminalInfo getOriginAccountInfo() {
    return originAccountInfo;
  }

  public void setOriginAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalInfo terminalInfo = (TerminalInfo) o;
    return Objects.equals(this.id, terminalInfo.id) &&
        Objects.equals(this.deviceId, terminalInfo.deviceId) &&
        Objects.equals(this.companyInfo, terminalInfo.companyInfo) &&
        Objects.equals(this.operateInfo, terminalInfo.operateInfo) &&
        Objects.equals(this.terminalNo, terminalInfo.terminalNo) &&
        Objects.equals(this.terminalName, terminalInfo.terminalName) &&
        Objects.equals(this.terminalType, terminalInfo.terminalType) &&
        Objects.equals(this.invoiceType, terminalInfo.invoiceType) &&
        Objects.equals(this.supportService, terminalInfo.supportService) &&
        Objects.equals(this.status, terminalInfo.status) &&
        Objects.equals(this.paddingLeft, terminalInfo.paddingLeft) &&
        Objects.equals(this.paddingTop, terminalInfo.paddingTop) &&
        Objects.equals(this.printInvoiceTerminalId, terminalInfo.printInvoiceTerminalId) &&
        Objects.equals(this.printSaleListTerminalId, terminalInfo.printSaleListTerminalId) &&
        Objects.equals(this.uKeySupportFlag, terminalInfo.uKeySupportFlag) &&
        Objects.equals(this.customExtra, terminalInfo.customExtra) &&
        Objects.equals(this.originAccountInfo, terminalInfo.originAccountInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deviceId, companyInfo, operateInfo, terminalNo, terminalName, terminalType, invoiceType, supportService, status, paddingLeft, paddingTop, printInvoiceTerminalId, printSaleListTerminalId, uKeySupportFlag, customExtra, originAccountInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    paddingLeft: ").append(toIndentedString(paddingLeft)).append("\n");
    sb.append("    paddingTop: ").append(toIndentedString(paddingTop)).append("\n");
    sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
    sb.append("    printSaleListTerminalId: ").append(toIndentedString(printSaleListTerminalId)).append("\n");
    sb.append("    uKeySupportFlag: ").append(toIndentedString(uKeySupportFlag)).append("\n");
    sb.append("    customExtra: ").append(toIndentedString(customExtra)).append("\n");
    sb.append("    originAccountInfo: ").append(toIndentedString(originAccountInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
