package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class TerminalSortInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonIgnore
  public TerminalSortInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号 （ASC 升序，DESC 降序）
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号 （ASC 升序，DESC 降序）")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public TerminalSortInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称 （ASC 升序，DESC 降序）
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称 （ASC 升序，DESC 降序）")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalSortInfo terminalSortInfo = (TerminalSortInfo) o;
    return Objects.equals(this.taxNo, terminalSortInfo.taxNo) &&
        Objects.equals(this.companyName, terminalSortInfo.companyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNo, companyName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalSortInfo {\n");
    
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
