package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * UnBindTerminalRequest
 */

@JsonInclude(NON_NULL)
public class UnBindTerminalRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public UnBindTerminalRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public UnBindTerminalRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public UnBindTerminalRequest terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/


  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public UnBindTerminalRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UnBindTerminalRequest unBindTerminalRequest = (UnBindTerminalRequest) o;
    return Objects.equals(this.head, unBindTerminalRequest.head) &&
        Objects.equals(this.deviceId, unBindTerminalRequest.deviceId) &&
        Objects.equals(this.terminalId, unBindTerminalRequest.terminalId) &&
        Objects.equals(this.operateInfo, unBindTerminalRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceId, terminalId, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UnBindTerminalRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
