package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireLicenseByKeyRequest
 */

@JsonInclude(NON_NULL)
public class AcquireLicenseByKeyRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("cid")
  private String cid = null;

  @JsonProperty("cidV2")
  private String cidV2 = null;

  @JsonProperty("key")
  private String key = null;

  @JsonProperty("loadFileFlag")
  private Boolean loadFileFlag = null;

  @JsonIgnore
  public AcquireLicenseByKeyRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireLicenseByKeyRequest cid(String cid) {
    this.cid = cid;
    return this;
  }

   /**
   * 客户端CID
   * @return cid
  **/


  @ApiModelProperty(value = "客户端CID")
  public String getCid() {
    return cid;
  }

  public void setCid(String cid) {
    this.cid = cid;
  }

  @JsonIgnore
  public AcquireLicenseByKeyRequest cidV2(String cidV2) {
    this.cidV2 = cidV2;
    return this;
  }

   /**
   * 客户端编号V2
   * @return cidV2
  **/


  @ApiModelProperty(value = "客户端编号V2")
  public String getCidV2() {
    return cidV2;
  }

  public void setCidV2(String cidV2) {
    this.cidV2 = cidV2;
  }

  @JsonIgnore
  public AcquireLicenseByKeyRequest key(String key) {
    this.key = key;
    return this;
  }

   /**
   * 激活码
   * @return key
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "激活码")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @JsonIgnore
  public AcquireLicenseByKeyRequest loadFileFlag(Boolean loadFileFlag) {
    this.loadFileFlag = loadFileFlag;
    return this;
  }

   /**
   * 获取授权文件标志，true：将授权文件Base64编码后返回
   * @return loadFileFlag
  **/


  @ApiModelProperty(value = "获取授权文件标志，true：将授权文件Base64编码后返回")
  public Boolean LoadFileFlag() {
    return loadFileFlag;
  }

  public void setLoadFileFlag(Boolean loadFileFlag) {
    this.loadFileFlag = loadFileFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireLicenseByKeyRequest acquireLicenseByKeyRequest = (AcquireLicenseByKeyRequest) o;
    return Objects.equals(this.head, acquireLicenseByKeyRequest.head) &&
        Objects.equals(this.cid, acquireLicenseByKeyRequest.cid) &&
        Objects.equals(this.cidV2, acquireLicenseByKeyRequest.cidV2) &&
        Objects.equals(this.key, acquireLicenseByKeyRequest.key) &&
        Objects.equals(this.loadFileFlag, acquireLicenseByKeyRequest.loadFileFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, cid, cidV2, key, loadFileFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireLicenseByKeyRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    cid: ").append(toIndentedString(cid)).append("\n");
    sb.append("    cidV2: ").append(toIndentedString(cidV2)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    loadFileFlag: ").append(toIndentedString(loadFileFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
