package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireLicenseRequest
 */

@JsonInclude(NON_NULL)
public class AcquireLicenseRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("licenseType")
  private Integer licenseType = null;

  @JsonProperty("acquireType")
  private Integer acquireType = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("taxDeviceNo")
  private String taxDeviceNo = null;

  @JsonProperty("loadFileFlag")
  private Boolean loadFileFlag = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public AcquireLicenseRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireLicenseRequest licenseType(Integer licenseType) {
    this.licenseType = licenseType;
    return this;
  }

   /**
   * 1 设备，2 终端
   * @return licenseType
  **/


  @ApiModelProperty(value = "1 设备，2 终端")
  public Integer getLicenseType() {
    return licenseType;
  }

  public void setLicenseType(Integer licenseType) {
    this.licenseType = licenseType;
  }

  @JsonIgnore
  public AcquireLicenseRequest acquireType(Integer acquireType) {
    this.acquireType = acquireType;
    return this;
  }

   /**
   * 1 根据id，2 纳税人识别号+开票机号，3 税号+税控设备编号
   * @return acquireType
  **/


  @ApiModelProperty(value = "1 根据id，2 纳税人识别号+开票机号，3 税号+税控设备编号")
  public Integer getAcquireType() {
    return acquireType;
  }

  public void setAcquireType(Integer acquireType) {
    this.acquireType = acquireType;
  }

  @JsonIgnore
  public AcquireLicenseRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 申请对象的id
   * @return id
  **/


  @ApiModelProperty(value = "申请对象的id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public AcquireLicenseRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public AcquireLicenseRequest taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号
   * @return taxDeviceMachineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public AcquireLicenseRequest taxDeviceNo(String taxDeviceNo) {
    this.taxDeviceNo = taxDeviceNo;
    return this;
  }

   /**
   * 税控设备编号
   * @return taxDeviceNo
  **/


  @ApiModelProperty(value = "税控设备编号")
  public String getTaxDeviceNo() {
    return taxDeviceNo;
  }

  public void setTaxDeviceNo(String taxDeviceNo) {
    this.taxDeviceNo = taxDeviceNo;
  }

  @JsonIgnore
  public AcquireLicenseRequest loadFileFlag(Boolean loadFileFlag) {
    this.loadFileFlag = loadFileFlag;
    return this;
  }

   /**
   * 获取授权文件标志，true：将授权文件Base64编码后返回
   * @return loadFileFlag
  **/


  @ApiModelProperty(value = "获取授权文件标志，true：将授权文件Base64编码后返回")
  public Boolean LoadFileFlag() {
    return loadFileFlag;
  }

  public void setLoadFileFlag(Boolean loadFileFlag) {
    this.loadFileFlag = loadFileFlag;
  }

  @JsonIgnore
  public AcquireLicenseRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireLicenseRequest acquireLicenseRequest = (AcquireLicenseRequest) o;
    return Objects.equals(this.head, acquireLicenseRequest.head) &&
        Objects.equals(this.licenseType, acquireLicenseRequest.licenseType) &&
        Objects.equals(this.acquireType, acquireLicenseRequest.acquireType) &&
        Objects.equals(this.id, acquireLicenseRequest.id) &&
        Objects.equals(this.taxNo, acquireLicenseRequest.taxNo) &&
        Objects.equals(this.taxDeviceMachineNo, acquireLicenseRequest.taxDeviceMachineNo) &&
        Objects.equals(this.taxDeviceNo, acquireLicenseRequest.taxDeviceNo) &&
        Objects.equals(this.loadFileFlag, acquireLicenseRequest.loadFileFlag) &&
        Objects.equals(this.operateInfo, acquireLicenseRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, licenseType, acquireType, id, taxNo, taxDeviceMachineNo, taxDeviceNo, loadFileFlag, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireLicenseRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    licenseType: ").append(toIndentedString(licenseType)).append("\n");
    sb.append("    acquireType: ").append(toIndentedString(acquireType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    taxDeviceNo: ").append(toIndentedString(taxDeviceNo)).append("\n");
    sb.append("    loadFileFlag: ").append(toIndentedString(loadFileFlag)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
