package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireTokenResponse1
 */

@JsonInclude(NON_NULL)
public class AcquireTokenResponse1 implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("stsToken")
  private String stsToken = null;

  @JsonProperty("accessKey")
  private String accessKey = null;

  @JsonProperty("secretKey")
  private String secretKey = null;

  @JsonProperty("expireAt")
  private String expireAt = null;

  @JsonIgnore
  public AcquireTokenResponse1 head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 获取token响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "获取token响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireTokenResponse1 stsToken(String stsToken) {
    this.stsToken = stsToken;
    return this;
  }

   /**
   * sts token
   * @return stsToken
  **/


  @ApiModelProperty(value = "sts token")
  public String getStsToken() {
    return stsToken;
  }

  public void setStsToken(String stsToken) {
    this.stsToken = stsToken;
  }

  @JsonIgnore
  public AcquireTokenResponse1 accessKey(String accessKey) {
    this.accessKey = accessKey;
    return this;
  }

   /**
   * accessKey
   * @return accessKey
  **/


  @ApiModelProperty(value = "accessKey")
  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  @JsonIgnore
  public AcquireTokenResponse1 secretKey(String secretKey) {
    this.secretKey = secretKey;
    return this;
  }

   /**
   * secretKey
   * @return secretKey
  **/


  @ApiModelProperty(value = "secretKey")
  public String getSecretKey() {
    return secretKey;
  }

  public void setSecretKey(String secretKey) {
    this.secretKey = secretKey;
  }

  @JsonIgnore
  public AcquireTokenResponse1 expireAt(String expireAt) {
    this.expireAt = expireAt;
    return this;
  }

   /**
   * 到期日期(yyyyMMddHHmmss)
   * @return expireAt
  **/


  @ApiModelProperty(value = "到期日期(yyyyMMddHHmmss)")
  public String getExpireAt() {
    return expireAt;
  }

  public void setExpireAt(String expireAt) {
    this.expireAt = expireAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireTokenResponse1 acquireTokenResponse1 = (AcquireTokenResponse1) o;
    return Objects.equals(this.head, acquireTokenResponse1.head) &&
        Objects.equals(this.stsToken, acquireTokenResponse1.stsToken) &&
        Objects.equals(this.accessKey, acquireTokenResponse1.accessKey) &&
        Objects.equals(this.secretKey, acquireTokenResponse1.secretKey) &&
        Objects.equals(this.expireAt, acquireTokenResponse1.expireAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, stsToken, accessKey, secretKey, expireAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireTokenResponse1 {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    stsToken: ").append(toIndentedString(stsToken)).append("\n");
    sb.append("    accessKey: ").append(toIndentedString(accessKey)).append("\n");
    sb.append("    secretKey: ").append(toIndentedString(secretKey)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
