package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AddTerminalResponse
 */

@JsonInclude(NON_NULL)
public class AddTerminalResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("unionId")
  private String unionId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonIgnore
  public AddTerminalResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 终端新增
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "终端新增")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AddTerminalResponse terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id（已废弃，用terminalUn代替）
   * @return terminalId
  **/


  @ApiModelProperty(value = "终端id（已废弃，用terminalUn代替）")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public AddTerminalResponse unionId(String unionId) {
    this.unionId = unionId;
    return this;
  }

   /**
   * 终端unionId（已废弃，用terminalUn代替）
   * @return unionId
  **/


  @ApiModelProperty(value = "终端unionId（已废弃，用terminalUn代替）")
  public String getUnionId() {
    return unionId;
  }

  public void setUnionId(String unionId) {
    this.unionId = unionId;
  }

  @JsonIgnore
  public AddTerminalResponse terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端唯一码
   * @return terminalUn
  **/


  @ApiModelProperty(value = "终端唯一码")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddTerminalResponse addTerminalResponse = (AddTerminalResponse) o;
    return Objects.equals(this.head, addTerminalResponse.head) &&
        Objects.equals(this.terminalId, addTerminalResponse.terminalId) &&
        Objects.equals(this.unionId, addTerminalResponse.unionId) &&
        Objects.equals(this.terminalUn, addTerminalResponse.terminalUn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalId, unionId, terminalUn);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddTerminalResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    unionId: ").append(toIndentedString(unionId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
