package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 客户端库存信息
 */
@ApiModel(description = "客户端库存信息")

@JsonInclude(NON_NULL)
public class ClientInvoiceStockInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceStockNum")
  private Long invoiceStockNum = null;

  @JsonProperty("invoiceStockDate")
  private String invoiceStockDate = null;

  @JsonIgnore
  public ClientInvoiceStockInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUn代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUn代替）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUn
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 公司税号
   * @return taxNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "公司税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号
   * @return taxDeviceMachineNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo invoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
    return this;
  }

   /**
   * 剩余发票
   * @return invoiceStockNum
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "剩余发票")
  public Long getInvoiceStockNum() {
    return invoiceStockNum;
  }

  public void setInvoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
  }

  @JsonIgnore
  public ClientInvoiceStockInfo invoiceStockDate(String invoiceStockDate) {
    this.invoiceStockDate = invoiceStockDate;
    return this;
  }

   /**
   * 库存数据更新时间 格式：yyyyMMddHHmmss
   * @return invoiceStockDate
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "库存数据更新时间 格式：yyyyMMddHHmmss")
  public String getInvoiceStockDate() {
    return invoiceStockDate;
  }

  public void setInvoiceStockDate(String invoiceStockDate) {
    this.invoiceStockDate = invoiceStockDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientInvoiceStockInfo clientInvoiceStockInfo = (ClientInvoiceStockInfo) o;
    return Objects.equals(this.deviceId, clientInvoiceStockInfo.deviceId) &&
        Objects.equals(this.deviceUn, clientInvoiceStockInfo.deviceUn) &&
        Objects.equals(this.deviceNo, clientInvoiceStockInfo.deviceNo) &&
        Objects.equals(this.deviceName, clientInvoiceStockInfo.deviceName) &&
        Objects.equals(this.taxNo, clientInvoiceStockInfo.taxNo) &&
        Objects.equals(this.taxDeviceMachineNo, clientInvoiceStockInfo.taxDeviceMachineNo) &&
        Objects.equals(this.invoiceType, clientInvoiceStockInfo.invoiceType) &&
        Objects.equals(this.invoiceStockNum, clientInvoiceStockInfo.invoiceStockNum) &&
        Objects.equals(this.invoiceStockDate, clientInvoiceStockInfo.invoiceStockDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, deviceUn, deviceNo, deviceName, taxNo, taxDeviceMachineNo, invoiceType, invoiceStockNum, invoiceStockDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientInvoiceStockInfo {\n");
    
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceStockNum: ").append(toIndentedString(invoiceStockNum)).append("\n");
    sb.append("    invoiceStockDate: ").append(toIndentedString(invoiceStockDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
