package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ClientStockResponse
 */

@JsonInclude(NON_NULL)
public class ClientStockResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("code")
  private String code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("traceId")
  private String traceId = null;

  @JsonIgnore
  public ClientStockResponse code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 系统代码
   * @return code
  **/


  @ApiModelProperty(value = "系统代码")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public ClientStockResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 信息
   * @return message
  **/


  @ApiModelProperty(value = "信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public ClientStockResponse traceId(String traceId) {
    this.traceId = traceId;
    return this;
  }

   /**
   * 内部调用id，调用接口出现问题，提供此字段给税件调查
   * @return traceId
  **/


  @ApiModelProperty(value = "内部调用id，调用接口出现问题，提供此字段给税件调查")
  public String getTraceId() {
    return traceId;
  }

  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientStockResponse clientStockResponse = (ClientStockResponse) o;
    return Objects.equals(this.code, clientStockResponse.code) &&
        Objects.equals(this.message, clientStockResponse.message) &&
        Objects.equals(this.traceId, clientStockResponse.traceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, traceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientStockResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
