package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ClientUpdateRequest
 */

@JsonInclude(NON_NULL)
public class ClientUpdateRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("taxDiskNo")
  private String taxDiskNo = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("clientVersion")
  private String clientVersion = null;

  @JsonProperty("updateVersion")
  private String updateVersion = null;

  @JsonProperty("path")
  private List<String> path = new ArrayList<>();

  @JsonIgnore
  public ClientUpdateRequest userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/


  @ApiModelProperty(value = "用户ID")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public ClientUpdateRequest taxDiskNo(String taxDiskNo) {
    this.taxDiskNo = taxDiskNo;
    return this;
  }

   /**
   * 税盘号
   * @return taxDiskNo
  **/


  @ApiModelProperty(value = "税盘号")
  public String getTaxDiskNo() {
    return taxDiskNo;
  }

  public void setTaxDiskNo(String taxDiskNo) {
    this.taxDiskNo = taxDiskNo;
  }

  @JsonIgnore
  public ClientUpdateRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号
   * @return taxNo
  **/


  @ApiModelProperty(value = "税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ClientUpdateRequest clientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
    return this;
  }

   /**
   * 当前客户端版本
   * @return clientVersion
  **/


  @ApiModelProperty(value = "当前客户端版本")
  public String getClientVersion() {
    return clientVersion;
  }

  public void setClientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
  }

  @JsonIgnore
  public ClientUpdateRequest updateVersion(String updateVersion) {
    this.updateVersion = updateVersion;
    return this;
  }

   /**
   * 目标客户端版本
   * @return updateVersion
  **/


  @ApiModelProperty(value = "目标客户端版本")
  public String getUpdateVersion() {
    return updateVersion;
  }

  public void setUpdateVersion(String updateVersion) {
    this.updateVersion = updateVersion;
  }

  @JsonIgnore
  public ClientUpdateRequest path(List<String> path) {
    this.path = path;
    return this;
  }

  public ClientUpdateRequest addPathItem(String pathItem) {
    this.path.add(pathItem);
    return this;
  }

   /**
   * OSS相对路径
   * @return path
  **/


  @ApiModelProperty(value = "OSS相对路径")
  public List<String> getPath() {
    return path;
  }

  public void setPath(List<String> path) {
    this.path = path;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientUpdateRequest clientUpdateRequest = (ClientUpdateRequest) o;
    return Objects.equals(this.userId, clientUpdateRequest.userId) &&
        Objects.equals(this.taxDiskNo, clientUpdateRequest.taxDiskNo) &&
        Objects.equals(this.taxNo, clientUpdateRequest.taxNo) &&
        Objects.equals(this.clientVersion, clientUpdateRequest.clientVersion) &&
        Objects.equals(this.updateVersion, clientUpdateRequest.updateVersion) &&
        Objects.equals(this.path, clientUpdateRequest.path);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, taxDiskNo, taxNo, clientVersion, updateVersion, path);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientUpdateRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    taxDiskNo: ").append(toIndentedString(taxDiskNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    clientVersion: ").append(toIndentedString(clientVersion)).append("\n");
    sb.append("    updateVersion: ").append(toIndentedString(updateVersion)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
