package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class CompanyInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("organizationId")
  private Long organizationId = null;

  @JsonProperty("organizationName")
  private String organizationName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxNos")
  private List<String> taxNos = new ArrayList<>();

  @JsonIgnore
  public CompanyInfo organizationId(Long organizationId) {
    this.organizationId = organizationId;
    return this;
  }

   /**
   * 组织id(用户中心体系-必填)
   * @return organizationId
  **/


  @ApiModelProperty(value = "组织id(用户中心体系-必填)")
  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  @JsonIgnore
  public CompanyInfo organizationName(String organizationName) {
    this.organizationName = organizationName;
    return this;
  }

   /**
   * 组织名称(用户中心体系-必填)
   * @return organizationName
  **/


  @ApiModelProperty(value = "组织名称(用户中心体系-必填)")
  public String getOrganizationName() {
    return organizationName;
  }

  public void setOrganizationName(String organizationName) {
    this.organizationName = organizationName;
  }

  @JsonIgnore
  public CompanyInfo tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 集团id(用户中心体系-必填)
   * @return tenantId
  **/


  @ApiModelProperty(value = "集团id(用户中心体系-必填)")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public CompanyInfo tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 集团名称(用户中心体系-必填)
   * @return tenantName
  **/


  @ApiModelProperty(value = "集团名称(用户中心体系-必填)")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public CompanyInfo companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id(用户中心体系-必填)
   * @return companyId
  **/


  @ApiModelProperty(value = "公司id(用户中心体系-必填)")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public CompanyInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称(用户中心体系-必填)
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称(用户中心体系-必填)")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public CompanyInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号(必填)
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号(必填)")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public CompanyInfo taxNos(List<String> taxNos) {
    this.taxNos = taxNos;
    return this;
  }

  public CompanyInfo addTaxNosItem(String taxNosItem) {
    this.taxNos.add(taxNosItem);
    return this;
  }

   /**
   * 纳税人识别号(仅用于查询使用)
   * @return taxNos
  **/


  @ApiModelProperty(value = "纳税人识别号(仅用于查询使用)")
  public List<String> getTaxNos() {
    return taxNos;
  }

  public void setTaxNos(List<String> taxNos) {
    this.taxNos = taxNos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyInfo companyInfo = (CompanyInfo) o;
    return Objects.equals(this.organizationId, companyInfo.organizationId) &&
        Objects.equals(this.organizationName, companyInfo.organizationName) &&
        Objects.equals(this.tenantId, companyInfo.tenantId) &&
        Objects.equals(this.tenantName, companyInfo.tenantName) &&
        Objects.equals(this.companyId, companyInfo.companyId) &&
        Objects.equals(this.companyName, companyInfo.companyName) &&
        Objects.equals(this.taxNo, companyInfo.taxNo) &&
        Objects.equals(this.taxNos, companyInfo.taxNos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organizationId, organizationName, tenantId, tenantName, companyId, companyName, taxNo, taxNos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyInfo {\n");
    
    sb.append("    organizationId: ").append(toIndentedString(organizationId)).append("\n");
    sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxNos: ").append(toIndentedString(taxNos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
