package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CompanyStampResponse
 */

@JsonInclude(NON_NULL)
public class CompanyStampResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("companyStampUrl")
  private String companyStampUrl = null;

  @JsonIgnore
  public CompanyStampResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public CompanyStampResponse companyStampUrl(String companyStampUrl) {
    this.companyStampUrl = companyStampUrl;
    return this;
  }

   /**
   * 公司签章URL
   * @return companyStampUrl
  **/


  @ApiModelProperty(value = "公司签章URL")
  public String getCompanyStampUrl() {
    return companyStampUrl;
  }

  public void setCompanyStampUrl(String companyStampUrl) {
    this.companyStampUrl = companyStampUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyStampResponse companyStampResponse = (CompanyStampResponse) o;
    return Objects.equals(this.head, companyStampResponse.head) &&
        Objects.equals(this.companyStampUrl, companyStampResponse.companyStampUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, companyStampUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyStampResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    companyStampUrl: ").append(toIndentedString(companyStampUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
