package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class Config implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("configKey")
  private String configKey = null;

  @JsonProperty("configValue")
  private String configValue = null;

  @JsonIgnore
  public Config configKey(String configKey) {
    this.configKey = configKey;
    return this;
  }

   /**
   * key
   * @return configKey
  **/


  @ApiModelProperty(value = "key")
  public String getConfigKey() {
    return configKey;
  }

  public void setConfigKey(String configKey) {
    this.configKey = configKey;
  }

  @JsonIgnore
  public Config configValue(String configValue) {
    this.configValue = configValue;
    return this;
  }

   /**
   * value
   * @return configValue
  **/


  @ApiModelProperty(value = "value")
  public String getConfigValue() {
    return configValue;
  }

  public void setConfigValue(String configValue) {
    this.configValue = configValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Config config = (Config) o;
    return Objects.equals(this.configKey, config.configKey) &&
        Objects.equals(this.configValue, config.configValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configKey, configValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Config {\n");
    
    sb.append("    configKey: ").append(toIndentedString(configKey)).append("\n");
    sb.append("    configValue: ").append(toIndentedString(configValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
