package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 客户端信息
 */
@ApiModel(description = "客户端信息")

@JsonInclude(NON_NULL)
public class HeartBeatClientInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("cloudVender")
  private String cloudVender = null;

  @JsonProperty("mKind")
  private String mKind = null;

  @JsonIgnore
  public HeartBeatClientInfo version(String version) {
    this.version = version;
    return this;
  }

   /**
   * 客户端版本
   * @return version
  **/


  @ApiModelProperty(value = "客户端版本")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @JsonIgnore
  public HeartBeatClientInfo cloudVender(String cloudVender) {
    this.cloudVender = cloudVender;
    return this;
  }

   /**
   * 云服务商标识[ac-阿里云提供服务 tc-腾讯云提供服务]
   * @return cloudVender
  **/


  @ApiModelProperty(value = "云服务商标识[ac-阿里云提供服务 tc-腾讯云提供服务]")
  public String getCloudVender() {
    return cloudVender;
  }

  public void setCloudVender(String cloudVender) {
    this.cloudVender = cloudVender;
  }

  @JsonIgnore
  public HeartBeatClientInfo mKind(String mKind) {
    this.mKind = mKind;
    return this;
  }

   /**
   * 开票模式[A、B、A2、B2]
   * @return mKind
  **/


  @ApiModelProperty(value = "开票模式[A、B、A2、B2]")
  public String getMKind() {
    return mKind;
  }

  public void setMKind(String mKind) {
    this.mKind = mKind;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HeartBeatClientInfo heartBeatClientInfo = (HeartBeatClientInfo) o;
    return Objects.equals(this.version, heartBeatClientInfo.version) &&
        Objects.equals(this.cloudVender, heartBeatClientInfo.cloudVender) &&
        Objects.equals(this.mKind, heartBeatClientInfo.mKind);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, cloudVender, mKind);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HeartBeatClientInfo {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    cloudVender: ").append(toIndentedString(cloudVender)).append("\n");
    sb.append("    mKind: ").append(toIndentedString(mKind)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
