package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 库存分发信息
 */
@ApiModel(description = "库存分发信息")

@JsonInclude(NON_NULL)
public class InvoiceDispatcherInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonIgnore
  public InvoiceDispatcherInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public InvoiceDispatcherInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDispatcherInfo invoiceDispatcherInfo = (InvoiceDispatcherInfo) o;
    return Objects.equals(this.requestSerialNo, invoiceDispatcherInfo.requestSerialNo) &&
        Objects.equals(this.deviceId, invoiceDispatcherInfo.deviceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, deviceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDispatcherInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
