package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.InvoiceRecycleResultInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceRecycleResultRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceRecycleResultRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceInfo")
  private InvoiceRecycleResultInfo deviceInfo = null;

  @JsonIgnore
  public InvoiceRecycleResultRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceRecycleResultRequest deviceInfo(InvoiceRecycleResultInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * 发票回收结果信息
   * @return deviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "发票回收结果信息")
  public InvoiceRecycleResultInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(InvoiceRecycleResultInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceRecycleResultRequest invoiceRecycleResultRequest = (InvoiceRecycleResultRequest) o;
    return Objects.equals(this.head, invoiceRecycleResultRequest.head) &&
        Objects.equals(this.deviceInfo, invoiceRecycleResultRequest.deviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceRecycleResultRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
