package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.ResponsePageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryDeviceResponse
 */

@JsonInclude(NON_NULL)
public class QueryDeviceResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("devices")
  private List<DeviceInfo> devices = new ArrayList<>();

  @JsonProperty("onlineDeviceIds")
  private List<Long> onlineDeviceIds = new ArrayList<>();

  @JsonProperty("onlineDeviceUns")
  private List<String> onlineDeviceUns = new ArrayList<>();

  @JsonProperty("originAccountOnlineDeviceIds")
  private List<Long> originAccountOnlineDeviceIds = new ArrayList<>();

  @JsonProperty("originAccountOnlineDeviceUns")
  private List<String> originAccountOnlineDeviceUns = new ArrayList<>();

  @JsonProperty("elSubscriptionQueues")
  private List<String> elSubscriptionQueues = new ArrayList<>();

  @JsonProperty("pageInfo")
  private ResponsePageInfo pageInfo = null;

  @JsonIgnore
  public QueryDeviceResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 设备信息获取响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "设备信息获取响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryDeviceResponse devices(List<DeviceInfo> devices) {
    this.devices = devices;
    return this;
  }

  public QueryDeviceResponse addDevicesItem(DeviceInfo devicesItem) {
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * 设备列表
   * @return devices
  **/

  @Valid

  @ApiModelProperty(value = "设备列表")
  public List<DeviceInfo> getDevices() {
    return devices;
  }

  public void setDevices(List<DeviceInfo> devices) {
    this.devices = devices;
  }

  @JsonIgnore
  public QueryDeviceResponse onlineDeviceIds(List<Long> onlineDeviceIds) {
    this.onlineDeviceIds = onlineDeviceIds;
    return this;
  }

  public QueryDeviceResponse addOnlineDeviceIdsItem(Long onlineDeviceIdsItem) {
    this.onlineDeviceIds.add(onlineDeviceIdsItem);
    return this;
  }

   /**
   * 直连在线设备列表,当查询在线状态参数为true时返回（已废弃，用onlineDeviceUns代替）
   * @return onlineDeviceIds
  **/


  @ApiModelProperty(value = "直连在线设备列表,当查询在线状态参数为true时返回（已废弃，用onlineDeviceUns代替）")
  public List<Long> getOnlineDeviceIds() {
    return onlineDeviceIds;
  }

  public void setOnlineDeviceIds(List<Long> onlineDeviceIds) {
    this.onlineDeviceIds = onlineDeviceIds;
  }

  @JsonIgnore
  public QueryDeviceResponse onlineDeviceUns(List<String> onlineDeviceUns) {
    this.onlineDeviceUns = onlineDeviceUns;
    return this;
  }

  public QueryDeviceResponse addOnlineDeviceUnsItem(String onlineDeviceUnsItem) {
    this.onlineDeviceUns.add(onlineDeviceUnsItem);
    return this;
  }

   /**
   * 直连在线设备列表,当查询在线状态参数为true时返回
   * @return onlineDeviceUns
  **/


  @ApiModelProperty(value = "直连在线设备列表,当查询在线状态参数为true时返回")
  public List<String> getOnlineDeviceUns() {
    return onlineDeviceUns;
  }

  public void setOnlineDeviceUns(List<String> onlineDeviceUns) {
    this.onlineDeviceUns = onlineDeviceUns;
  }

  @JsonIgnore
  public QueryDeviceResponse originAccountOnlineDeviceIds(List<Long> originAccountOnlineDeviceIds) {
    this.originAccountOnlineDeviceIds = originAccountOnlineDeviceIds;
    return this;
  }

  public QueryDeviceResponse addOriginAccountOnlineDeviceIdsItem(Long originAccountOnlineDeviceIdsItem) {
    this.originAccountOnlineDeviceIds.add(originAccountOnlineDeviceIdsItem);
    return this;
  }

   /**
   * 底账在线列表,当查询在线状态参数为true时返回（已废弃，用originAccountOnlineDeviceUns代替）
   * @return originAccountOnlineDeviceIds
  **/


  @ApiModelProperty(value = "底账在线列表,当查询在线状态参数为true时返回（已废弃，用originAccountOnlineDeviceUns代替）")
  public List<Long> getOriginAccountOnlineDeviceIds() {
    return originAccountOnlineDeviceIds;
  }

  public void setOriginAccountOnlineDeviceIds(List<Long> originAccountOnlineDeviceIds) {
    this.originAccountOnlineDeviceIds = originAccountOnlineDeviceIds;
  }

  @JsonIgnore
  public QueryDeviceResponse originAccountOnlineDeviceUns(List<String> originAccountOnlineDeviceUns) {
    this.originAccountOnlineDeviceUns = originAccountOnlineDeviceUns;
    return this;
  }

  public QueryDeviceResponse addOriginAccountOnlineDeviceUnsItem(String originAccountOnlineDeviceUnsItem) {
    this.originAccountOnlineDeviceUns.add(originAccountOnlineDeviceUnsItem);
    return this;
  }

   /**
   * 底账在线列表,当查询在线状态参数为true时返回
   * @return originAccountOnlineDeviceUns
  **/


  @ApiModelProperty(value = "底账在线列表,当查询在线状态参数为true时返回")
  public List<String> getOriginAccountOnlineDeviceUns() {
    return originAccountOnlineDeviceUns;
  }

  public void setOriginAccountOnlineDeviceUns(List<String> originAccountOnlineDeviceUns) {
    this.originAccountOnlineDeviceUns = originAccountOnlineDeviceUns;
  }

  @JsonIgnore
  public QueryDeviceResponse elSubscriptionQueues(List<String> elSubscriptionQueues) {
    this.elSubscriptionQueues = elSubscriptionQueues;
    return this;
  }

  public QueryDeviceResponse addElSubscriptionQueuesItem(String elSubscriptionQueuesItem) {
    this.elSubscriptionQueues.add(elSubscriptionQueuesItem);
    return this;
  }

   /**
   * 底账队列,当查询底账订阅队列为true时返回
   * @return elSubscriptionQueues
  **/


  @ApiModelProperty(value = "底账队列,当查询底账订阅队列为true时返回")
  public List<String> getElSubscriptionQueues() {
    return elSubscriptionQueues;
  }

  public void setElSubscriptionQueues(List<String> elSubscriptionQueues) {
    this.elSubscriptionQueues = elSubscriptionQueues;
  }

  @JsonIgnore
  public QueryDeviceResponse pageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public ResponsePageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryDeviceResponse queryDeviceResponse = (QueryDeviceResponse) o;
    return Objects.equals(this.head, queryDeviceResponse.head) &&
        Objects.equals(this.devices, queryDeviceResponse.devices) &&
        Objects.equals(this.onlineDeviceIds, queryDeviceResponse.onlineDeviceIds) &&
        Objects.equals(this.onlineDeviceUns, queryDeviceResponse.onlineDeviceUns) &&
        Objects.equals(this.originAccountOnlineDeviceIds, queryDeviceResponse.originAccountOnlineDeviceIds) &&
        Objects.equals(this.originAccountOnlineDeviceUns, queryDeviceResponse.originAccountOnlineDeviceUns) &&
        Objects.equals(this.elSubscriptionQueues, queryDeviceResponse.elSubscriptionQueues) &&
        Objects.equals(this.pageInfo, queryDeviceResponse.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, devices, onlineDeviceIds, onlineDeviceUns, originAccountOnlineDeviceIds, originAccountOnlineDeviceUns, elSubscriptionQueues, pageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryDeviceResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    onlineDeviceIds: ").append(toIndentedString(onlineDeviceIds)).append("\n");
    sb.append("    onlineDeviceUns: ").append(toIndentedString(onlineDeviceUns)).append("\n");
    sb.append("    originAccountOnlineDeviceIds: ").append(toIndentedString(originAccountOnlineDeviceIds)).append("\n");
    sb.append("    originAccountOnlineDeviceUns: ").append(toIndentedString(originAccountOnlineDeviceUns)).append("\n");
    sb.append("    elSubscriptionQueues: ").append(toIndentedString(elSubscriptionQueues)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
