package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.QuerySqsStatusResponseQueueStatus;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QuerySqsStatusResponse
 */

@JsonInclude(NON_NULL)
public class QuerySqsStatusResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("queueStatus")
  private List<QuerySqsStatusResponseQueueStatus> queueStatus = new ArrayList<>();

  @JsonIgnore
  public QuerySqsStatusResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询队列状态响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询队列状态响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QuerySqsStatusResponse queueStatus(List<QuerySqsStatusResponseQueueStatus> queueStatus) {
    this.queueStatus = queueStatus;
    return this;
  }

  public QuerySqsStatusResponse addQueueStatusItem(QuerySqsStatusResponseQueueStatus queueStatusItem) {
    this.queueStatus.add(queueStatusItem);
    return this;
  }

   /**
   * Get queueStatus
   * @return queueStatus
  **/

  @Valid

  @ApiModelProperty(value = "")
  public List<QuerySqsStatusResponseQueueStatus> getQueueStatus() {
    return queueStatus;
  }

  public void setQueueStatus(List<QuerySqsStatusResponseQueueStatus> queueStatus) {
    this.queueStatus = queueStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuerySqsStatusResponse querySqsStatusResponse = (QuerySqsStatusResponse) o;
    return Objects.equals(this.head, querySqsStatusResponse.head) &&
        Objects.equals(this.queueStatus, querySqsStatusResponse.queueStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queueStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuerySqsStatusResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queueStatus: ").append(toIndentedString(queueStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
