package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class QueueInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("lastOfflineTime")
  private String lastOfflineTime = null;

  @JsonProperty("lastOnlineTime")
  private String lastOnlineTime = null;

  @JsonIgnore
  public QueueInfo queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 队列名称
   * @return queueName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "队列名称")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public QueueInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 在线状态,0-不在线，1-在线,-1-未知
   * @return status
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "在线状态,0-不在线，1-在线,-1-未知")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public QueueInfo lastOfflineTime(String lastOfflineTime) {
    this.lastOfflineTime = lastOfflineTime;
    return this;
  }

   /**
   * 最近一次下线时间,yyyyMMddHHmmss
   * @return lastOfflineTime
  **/


  @ApiModelProperty(value = "最近一次下线时间,yyyyMMddHHmmss")
  public String getLastOfflineTime() {
    return lastOfflineTime;
  }

  public void setLastOfflineTime(String lastOfflineTime) {
    this.lastOfflineTime = lastOfflineTime;
  }

  @JsonIgnore
  public QueueInfo lastOnlineTime(String lastOnlineTime) {
    this.lastOnlineTime = lastOnlineTime;
    return this;
  }

   /**
   * 最近一次上线时间,yyyyMMddHHmmss
   * @return lastOnlineTime
  **/


  @ApiModelProperty(value = "最近一次上线时间,yyyyMMddHHmmss")
  public String getLastOnlineTime() {
    return lastOnlineTime;
  }

  public void setLastOnlineTime(String lastOnlineTime) {
    this.lastOnlineTime = lastOnlineTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueueInfo queueInfo = (QueueInfo) o;
    return Objects.equals(this.queueName, queueInfo.queueName) &&
        Objects.equals(this.status, queueInfo.status) &&
        Objects.equals(this.lastOfflineTime, queueInfo.lastOfflineTime) &&
        Objects.equals(this.lastOnlineTime, queueInfo.lastOnlineTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queueName, status, lastOfflineTime, lastOnlineTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueueInfo {\n");
    
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    lastOfflineTime: ").append(toIndentedString(lastOfflineTime)).append("\n");
    sb.append("    lastOnlineTime: ").append(toIndentedString(lastOnlineTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
