package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SendLicenseRequest
 */

@JsonInclude(NON_NULL)
public class SendLicenseRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("licenseType")
  private Integer licenseType = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("un")
  private String un = null;

  @JsonProperty("receiverEmail")
  private String receiverEmail = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public SendLicenseRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public SendLicenseRequest licenseType(Integer licenseType) {
    this.licenseType = licenseType;
    return this;
  }

   /**
   * 1 设备，2 终端
   * @return licenseType
  **/


  @ApiModelProperty(value = "1 设备，2 终端")
  public Integer getLicenseType() {
    return licenseType;
  }

  public void setLicenseType(Integer licenseType) {
    this.licenseType = licenseType;
  }

  @JsonIgnore
  public SendLicenseRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 申请对象的id（已废弃，用申请对象唯一码代替）
   * @return id
  **/


  @ApiModelProperty(value = "申请对象的id（已废弃，用申请对象唯一码代替）")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public SendLicenseRequest un(String un) {
    this.un = un;
    return this;
  }

   /**
   * 申请对象的唯一码
   * @return un
  **/


  @ApiModelProperty(value = "申请对象的唯一码")
  public String getUn() {
    return un;
  }

  public void setUn(String un) {
    this.un = un;
  }

  @JsonIgnore
  public SendLicenseRequest receiverEmail(String receiverEmail) {
    this.receiverEmail = receiverEmail;
    return this;
  }

   /**
   * 接收者邮箱
   * @return receiverEmail
  **/


  @ApiModelProperty(value = "接收者邮箱")
  public String getReceiverEmail() {
    return receiverEmail;
  }

  public void setReceiverEmail(String receiverEmail) {
    this.receiverEmail = receiverEmail;
  }

  @JsonIgnore
  public SendLicenseRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendLicenseRequest sendLicenseRequest = (SendLicenseRequest) o;
    return Objects.equals(this.head, sendLicenseRequest.head) &&
        Objects.equals(this.licenseType, sendLicenseRequest.licenseType) &&
        Objects.equals(this.id, sendLicenseRequest.id) &&
        Objects.equals(this.un, sendLicenseRequest.un) &&
        Objects.equals(this.receiverEmail, sendLicenseRequest.receiverEmail) &&
        Objects.equals(this.operateInfo, sendLicenseRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, licenseType, id, un, receiverEmail, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendLicenseRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    licenseType: ").append(toIndentedString(licenseType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    un: ").append(toIndentedString(un)).append("\n");
    sb.append("    receiverEmail: ").append(toIndentedString(receiverEmail)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
