package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.SubscribeDeviceStockInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 税盘库存订阅信息
 */
@ApiModel(description = "税盘库存订阅信息")

@JsonInclude(NON_NULL)
public class SubscribeDeviceStock implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("subscribeDeviceStockList")
  private List<SubscribeDeviceStockInfo> subscribeDeviceStockList = new ArrayList<>();

  @JsonIgnore
  public SubscribeDeviceStock subscribeDeviceStockList(List<SubscribeDeviceStockInfo> subscribeDeviceStockList) {
    this.subscribeDeviceStockList = subscribeDeviceStockList;
    return this;
  }

  public SubscribeDeviceStock addSubscribeDeviceStockListItem(SubscribeDeviceStockInfo subscribeDeviceStockListItem) {
    this.subscribeDeviceStockList.add(subscribeDeviceStockListItem);
    return this;
  }

   /**
   * 税盘抽取订阅信息
   * @return subscribeDeviceStockList
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "税盘抽取订阅信息")
  public List<SubscribeDeviceStockInfo> getSubscribeDeviceStockList() {
    return subscribeDeviceStockList;
  }

  public void setSubscribeDeviceStockList(List<SubscribeDeviceStockInfo> subscribeDeviceStockList) {
    this.subscribeDeviceStockList = subscribeDeviceStockList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeDeviceStock subscribeDeviceStock = (SubscribeDeviceStock) o;
    return Objects.equals(this.subscribeDeviceStockList, subscribeDeviceStock.subscribeDeviceStockList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subscribeDeviceStockList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeDeviceStock {\n");
    
    sb.append("    subscribeDeviceStockList: ").append(toIndentedString(subscribeDeviceStockList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
