package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 税盘库存订阅信息
 */
@ApiModel(description = "税盘库存订阅信息")

@JsonInclude(NON_NULL)
public class SubscribeDeviceStockInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("subscribeType")
  private Integer subscribeType = null;

  @JsonProperty("subscribeValue")
  private String subscribeValue = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonIgnore
  public SubscribeDeviceStockInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 税盘唯一码
   * @return deviceUn
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "税盘唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public SubscribeDeviceStockInfo subscribeType(Integer subscribeType) {
    this.subscribeType = subscribeType;
    return this;
  }

   /**
   * 订阅类型：1【SQS】
   * @return subscribeType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "订阅类型：1【SQS】")
  public Integer getSubscribeType() {
    return subscribeType;
  }

  public void setSubscribeType(Integer subscribeType) {
    this.subscribeType = subscribeType;
  }

  @JsonIgnore
  public SubscribeDeviceStockInfo subscribeValue(String subscribeValue) {
    this.subscribeValue = subscribeValue;
    return this;
  }

   /**
   * 订阅地址：订阅类型为1时【SQS队列名】
   * @return subscribeValue
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "订阅地址：订阅类型为1时【SQS队列名】")
  public String getSubscribeValue() {
    return subscribeValue;
  }

  public void setSubscribeValue(String subscribeValue) {
    this.subscribeValue = subscribeValue;
  }

  @JsonIgnore
  public SubscribeDeviceStockInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeDeviceStockInfo subscribeDeviceStockInfo = (SubscribeDeviceStockInfo) o;
    return Objects.equals(this.deviceUn, subscribeDeviceStockInfo.deviceUn) &&
        Objects.equals(this.subscribeType, subscribeDeviceStockInfo.subscribeType) &&
        Objects.equals(this.subscribeValue, subscribeDeviceStockInfo.subscribeValue) &&
        Objects.equals(this.fromSystem, subscribeDeviceStockInfo.fromSystem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceUn, subscribeType, subscribeValue, fromSystem);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeDeviceStockInfo {\n");
    
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    subscribeType: ").append(toIndentedString(subscribeType)).append("\n");
    sb.append("    subscribeValue: ").append(toIndentedString(subscribeValue)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
