package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.TerminalBindClientResponseQueryClientInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * TerminalBindClientResponse
 */

@JsonInclude(NON_NULL)
public class TerminalBindClientResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("queryClientInfo")
  private List<TerminalBindClientResponseQueryClientInfo> queryClientInfo = new ArrayList<>();

  @JsonIgnore
  public TerminalBindClientResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询终端绑定的客户端响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询终端绑定的客户端响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public TerminalBindClientResponse queryClientInfo(List<TerminalBindClientResponseQueryClientInfo> queryClientInfo) {
    this.queryClientInfo = queryClientInfo;
    return this;
  }

  public TerminalBindClientResponse addQueryClientInfoItem(TerminalBindClientResponseQueryClientInfo queryClientInfoItem) {
    this.queryClientInfo.add(queryClientInfoItem);
    return this;
  }

   /**
   * Get queryClientInfo
   * @return queryClientInfo
  **/

  @Valid

  @ApiModelProperty(value = "")
  public List<TerminalBindClientResponseQueryClientInfo> getQueryClientInfo() {
    return queryClientInfo;
  }

  public void setQueryClientInfo(List<TerminalBindClientResponseQueryClientInfo> queryClientInfo) {
    this.queryClientInfo = queryClientInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalBindClientResponse terminalBindClientResponse = (TerminalBindClientResponse) o;
    return Objects.equals(this.head, terminalBindClientResponse.head) &&
        Objects.equals(this.queryClientInfo, terminalBindClientResponse.queryClientInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queryClientInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalBindClientResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queryClientInfo: ").append(toIndentedString(queryClientInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
