package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.DeviceExtraInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 更新设备信息
 */
@ApiModel(description = "更新设备信息")

@JsonInclude(NON_NULL)
public class UpdateDeviceInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<>();

  @JsonProperty("extraInfo")
  private DeviceExtraInfo extraInfo = null;

  @JsonProperty("taxDeviceInfo")
  private TaxDeviceInfo taxDeviceInfo = null;

  @JsonIgnore
  public UpdateDeviceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUn代替）
   * @return id
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUn代替）")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUn
  **/


  @ApiModelProperty(value = "设备唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public UpdateDeviceInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号（审核通过后，taxVUKey类型的设备编号，不可修改）
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号（审核通过后，taxVUKey类型的设备编号，不可修改）")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/


  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * 设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书
   * @return deviceType
  **/


  @ApiModelProperty(value = "设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public UpdateDeviceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/


  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public UpdateDeviceInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public UpdateDeviceInfo service(List<String> service) {
    this.service = service;
    return this;
  }

  public UpdateDeviceInfo addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）（taxVUKey类型支持服务不支持修改）
   * @return service
  **/


  @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）（taxVUKey类型支持服务不支持修改）")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }

  @JsonIgnore
  public UpdateDeviceInfo extraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
    return this;
  }

   /**
   * 配置信息
   * @return extraInfo
  **/

  @Valid

  @ApiModelProperty(value = "配置信息")
  public DeviceExtraInfo getExtraInfo() {
    return extraInfo;
  }

  public void setExtraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
  }

  @JsonIgnore
  public UpdateDeviceInfo taxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "税控设备消息")
  public TaxDeviceInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateDeviceInfo updateDeviceInfo = (UpdateDeviceInfo) o;
    return Objects.equals(this.id, updateDeviceInfo.id) &&
        Objects.equals(this.deviceUn, updateDeviceInfo.deviceUn) &&
        Objects.equals(this.operateInfo, updateDeviceInfo.operateInfo) &&
        Objects.equals(this.deviceNo, updateDeviceInfo.deviceNo) &&
        Objects.equals(this.deviceName, updateDeviceInfo.deviceName) &&
        Objects.equals(this.deviceType, updateDeviceInfo.deviceType) &&
        Objects.equals(this.remark, updateDeviceInfo.remark) &&
        Objects.equals(this.fromSystem, updateDeviceInfo.fromSystem) &&
        Objects.equals(this.service, updateDeviceInfo.service) &&
        Objects.equals(this.extraInfo, updateDeviceInfo.extraInfo) &&
        Objects.equals(this.taxDeviceInfo, updateDeviceInfo.taxDeviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deviceUn, operateInfo, deviceNo, deviceName, deviceType, remark, fromSystem, service, extraInfo, taxDeviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateDeviceInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
