package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.hardware.model.DeviceStatusDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 设备状态消息
 *
 * @author Bobo
 * @create 2020/4/21 20:35
 * @since 1.0.0
 */
public class DeviceStatusMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceStatusMessage.Response.Result result = new DeviceStatusMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 设备状态
             */
            private List<DeviceStatusDto> status;

        }

    }
}
