package com.xforceplus.micro.tax.device.contract.model.hardware.model;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.OrganizationDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/5/6 16:14
 * @since 1.0.0
 */
public class AddHardwareMessage {
    @Data
    public static class Request {

        /**
         * 支持服务
         * make：开票 ，originAccount：底账，assistant：辅助
         */
        private List<String> supportService;

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 创建人
         */
        private String createdBy;

        /**
         * 终端名称
         */
        private String terminalName;

        /**
         * 发票类型列表
         */
        private List<String> invoiceTypeList;

        /**
         * 组织信息
         */
        private OrganizationDto organization;

        /**
         * 设备(仅支持终端类型是虚拟UKey时，创建新的虚拟ukey设备或者绑定已有虚拟ukey设备)
         */
        private AddHardwareMessage.Request.DeviceDto deviceInfo = new AddHardwareMessage.Request.DeviceDto();

        @Data
        public static class DeviceDto {

            /**
             * 设备编号
             */
            private String deviceNo;

            /**
             * 设备类型
             * 1:百旺税控盘 2:百旺税控钥匙 3:航信金税盘 4:航信税控钥匙
             */
            private Integer deviceType;

            /**
             * 开票机号
             */
            private Integer taxDeviceMachineNo;

            /**
             * 国税自定义密码
             */
            private String nationalTaxPassword;

            /**
             * 抵扣统计确认密码
             */
            private String elConfirmPassword;

            /**
             * 税务数字证书密码
             */
            private String taxDeviceDigitalPassword;

            /**
             * 税控盘密码
             */
            private String taxDevicePassword;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private AddHardwareMessage.Result result = new AddHardwareMessage.Result();
    }

    @Data
    public static class Result {

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 设备唯一编号
         */
        private String deviceUn;

        /**
         * 激活码
         */
        private String activationCode;

        /**
         * 激活码有效期至（格式：yyyy/MM/dd）
         */
        private String activationCodeExpireAt;

    }
}
