package com.xforceplus.micro.tax.device.contract.model.hardware.model;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.OrganizationDto;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * pubsub消息设备模型
 *
 * @author Bobo
 * @create 2020/6/11 13:37
 * @since 1.0.0
 */
@Data
@Builder
public class PubSubDeviceDto {

    /**
     * 设备唯一编号
     */
    private String deviceUn;

    /**
     * 设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书
     */
    private String deviceType;

    /**
     * 支持服务
     * make：开票 ，originAccount：底账，assistant：辅助
     */
    private List<String> supportService;

    /**
     * 设备状态(0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭)
     */
    private Integer status;

    /**
     * 纳税人识别号
     */
    private String taxCode;

    /**
     * 终端Id
     */
    private Long terminalId;

    /**
     * 终端唯一码
     */
    private String terminalUn;

    /**
     * 组织信息
     */
    private OrganizationDto organization;

    /**
     * 操作类型(create-创建，update-修改)
     */
    private String actionType;


}
