package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 客户端信息
 */
@ApiModel(description = "客户端信息")

@JsonInclude(NON_NULL)
public class ClientInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("cid")
  private String cid = null;

  @JsonProperty("cidV2")
  private String cidV2 = null;

  @JsonProperty("hostName")
  private String hostName = null;

  @JsonProperty("ip")
  private String ip = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("version")
  private String version = null;

  @JsonIgnore
  public ClientInfo cid(String cid) {
    this.cid = cid;
    return this;
  }

   /**
   * 客户端编号
   * @return cid
  **/


  @ApiModelProperty(value = "客户端编号")
  public String getCid() {
    return cid;
  }

  public void setCid(String cid) {
    this.cid = cid;
  }

  @JsonIgnore
  public ClientInfo cidV2(String cidV2) {
    this.cidV2 = cidV2;
    return this;
  }

   /**
   * 客户端编号V2
   * @return cidV2
  **/


  @ApiModelProperty(value = "客户端编号V2")
  public String getCidV2() {
    return cidV2;
  }

  public void setCidV2(String cidV2) {
    this.cidV2 = cidV2;
  }

  @JsonIgnore
  public ClientInfo hostName(String hostName) {
    this.hostName = hostName;
    return this;
  }

   /**
   * 主机名
   * @return hostName
  **/


  @ApiModelProperty(value = "主机名")
  public String getHostName() {
    return hostName;
  }

  public void setHostName(String hostName) {
    this.hostName = hostName;
  }

  @JsonIgnore
  public ClientInfo ip(String ip) {
    this.ip = ip;
    return this;
  }

   /**
   * 客户端ip
   * @return ip
  **/


  @ApiModelProperty(value = "客户端ip")
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  @JsonIgnore
  public ClientInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 客户端名称
   * @return name
  **/


  @ApiModelProperty(value = "客户端名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public ClientInfo version(String version) {
    this.version = version;
    return this;
  }

   /**
   * 客户端版本
   * @return version
  **/


  @ApiModelProperty(value = "客户端版本")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientInfo clientInfo = (ClientInfo) o;
    return Objects.equals(this.cid, clientInfo.cid) &&
        Objects.equals(this.cidV2, clientInfo.cidV2) &&
        Objects.equals(this.hostName, clientInfo.hostName) &&
        Objects.equals(this.ip, clientInfo.ip) &&
        Objects.equals(this.name, clientInfo.name) &&
        Objects.equals(this.version, clientInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cid, cidV2, hostName, ip, name, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientInfo {\n");
    
    sb.append("    cid: ").append(toIndentedString(cid)).append("\n");
    sb.append("    cidV2: ").append(toIndentedString(cidV2)).append("\n");
    sb.append("    hostName: ").append(toIndentedString(hostName)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
