package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 客户端库存查询条件信息
 */
@ApiModel(description = "客户端库存查询条件信息")

@JsonInclude(NON_NULL)
public class ClientInvoiceStockQueryInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("miUserId")
  private String miUserId = null;

  @JsonIgnore
  public ClientInvoiceStockQueryInfo miUserId(String miUserId) {
    this.miUserId = miUserId;
    return this;
  }

   /**
   * Mi账号
   * @return miUserId
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "Mi账号")
  public String getMiUserId() {
    return miUserId;
  }

  public void setMiUserId(String miUserId) {
    this.miUserId = miUserId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientInvoiceStockQueryInfo clientInvoiceStockQueryInfo = (ClientInvoiceStockQueryInfo) o;
    return Objects.equals(this.miUserId, clientInvoiceStockQueryInfo.miUserId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(miUserId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientInvoiceStockQueryInfo {\n");
    
    sb.append("    miUserId: ").append(toIndentedString(miUserId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
