package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 公司信息查询字段
 */
@ApiModel(description = "公司信息查询字段")

@JsonInclude(NON_NULL)
public class CompanyQueryInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("organizationId")
  private List<Long> organizationId = new ArrayList<>();

  @JsonProperty("organizationName")
  private String organizationName = null;

  @JsonProperty("tenantId")
  private List<Long> tenantId = new ArrayList<>();

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("companyId")
  private List<Long> companyId = new ArrayList<>();

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxNos")
  private List<String> taxNos = new ArrayList<>();

  @JsonIgnore
  public CompanyQueryInfo organizationId(List<Long> organizationId) {
    this.organizationId = organizationId;
    return this;
  }

  public CompanyQueryInfo addOrganizationIdItem(Long organizationIdItem) {
    this.organizationId.add(organizationIdItem);
    return this;
  }

   /**
   * 组织id
   * @return organizationId
  **/


  @ApiModelProperty(value = "组织id")
  public List<Long> getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(List<Long> organizationId) {
    this.organizationId = organizationId;
  }

  @JsonIgnore
  public CompanyQueryInfo organizationName(String organizationName) {
    this.organizationName = organizationName;
    return this;
  }

   /**
   * 组织名称
   * @return organizationName
  **/


  @ApiModelProperty(value = "组织名称")
  public String getOrganizationName() {
    return organizationName;
  }

  public void setOrganizationName(String organizationName) {
    this.organizationName = organizationName;
  }

  @JsonIgnore
  public CompanyQueryInfo tenantId(List<Long> tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  public CompanyQueryInfo addTenantIdItem(Long tenantIdItem) {
    this.tenantId.add(tenantIdItem);
    return this;
  }

   /**
   * 集团id
   * @return tenantId
  **/


  @ApiModelProperty(value = "集团id")
  public List<Long> getTenantId() {
    return tenantId;
  }

  public void setTenantId(List<Long> tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public CompanyQueryInfo tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 集团名称
   * @return tenantName
  **/


  @ApiModelProperty(value = "集团名称")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public CompanyQueryInfo companyId(List<Long> companyId) {
    this.companyId = companyId;
    return this;
  }

  public CompanyQueryInfo addCompanyIdItem(Long companyIdItem) {
    this.companyId.add(companyIdItem);
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/


  @ApiModelProperty(value = "公司id")
  public List<Long> getCompanyId() {
    return companyId;
  }

  public void setCompanyId(List<Long> companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public CompanyQueryInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public CompanyQueryInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public CompanyQueryInfo taxNos(List<String> taxNos) {
    this.taxNos = taxNos;
    return this;
  }

  public CompanyQueryInfo addTaxNosItem(String taxNosItem) {
    this.taxNos.add(taxNosItem);
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNos
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public List<String> getTaxNos() {
    return taxNos;
  }

  public void setTaxNos(List<String> taxNos) {
    this.taxNos = taxNos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyQueryInfo companyQueryInfo = (CompanyQueryInfo) o;
    return Objects.equals(this.organizationId, companyQueryInfo.organizationId) &&
        Objects.equals(this.organizationName, companyQueryInfo.organizationName) &&
        Objects.equals(this.tenantId, companyQueryInfo.tenantId) &&
        Objects.equals(this.tenantName, companyQueryInfo.tenantName) &&
        Objects.equals(this.companyId, companyQueryInfo.companyId) &&
        Objects.equals(this.companyName, companyQueryInfo.companyName) &&
        Objects.equals(this.taxNo, companyQueryInfo.taxNo) &&
        Objects.equals(this.taxNos, companyQueryInfo.taxNos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organizationId, organizationName, tenantId, tenantName, companyId, companyName, taxNo, taxNos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyQueryInfo {\n");
    
    sb.append("    organizationId: ").append(toIndentedString(organizationId)).append("\n");
    sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxNos: ").append(toIndentedString(taxNos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
