package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceExtraInfo;
import com.xforceplus.micro.tax.device.contract.model.HeartBeatClientInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonInclude(NON_NULL)
public class DeviceInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("companyInfo")
  private CompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("sqsDirectOnlineFlag")
  private Boolean sqsDirectOnlineFlag = false;

  @JsonProperty("amqQueueOnlineFlag")
  private Boolean amqQueueOnlineFlag = null;

  @JsonProperty("amqDirectOnlineFlag")
  private Boolean amqDirectOnlineFlag = false;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("sqsQueueName")
  private String sqsQueueName = null;

  @JsonProperty("clientInfo")
  private HeartBeatClientInfo clientInfo = null;

  @JsonProperty("originAccountQueueName")
  private String originAccountQueueName = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<>();

  @JsonProperty("status")
  private Integer status = 0;

  @JsonProperty("hasLicenseFlag")
  private Boolean hasLicenseFlag = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("elSubscriptionQueues")
  private List<String> elSubscriptionQueues = new ArrayList<>();

  @JsonProperty("extraInfo")
  private DeviceExtraInfo extraInfo = null;

  @JsonProperty("taxDeviceInfo")
  private TaxDeviceInfo taxDeviceInfo = null;

  @JsonIgnore
  public DeviceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备id，查询时返回 （已废弃，用deviceUn代替）
   * @return id
  **/


  @ApiModelProperty(value = "设备id，查询时返回 （已废弃，用deviceUn代替）")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public DeviceInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUn
  **/


  @ApiModelProperty(value = "设备唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public DeviceInfo companyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "公司信息")
  public CompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public DeviceInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public DeviceInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号(税控设备为5-VUKey时，必不填)
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号(税控设备为5-VUKey时，必不填)")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public DeviceInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称(非必填，默认名称：设备编号)
   * @return deviceName
  **/


  @ApiModelProperty(value = "设备名称(非必填，默认名称：设备编号)")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public DeviceInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * 设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书(税控设备为5、8、7时，系统自动维护)
   * @return deviceType
  **/


  @ApiModelProperty(value = "设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书(税控设备为5、8、7时，系统自动维护)")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public DeviceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/


  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public DeviceInfo sqsDirectOnlineFlag(Boolean sqsDirectOnlineFlag) {
    this.sqsDirectOnlineFlag = sqsDirectOnlineFlag;
    return this;
  }

   /**
   * SQS直连在线标志,true:在线 false:不在线
   * @return sqsDirectOnlineFlag
  **/


  @ApiModelProperty(value = "SQS直连在线标志,true:在线 false:不在线")
  public Boolean SqsDirectOnlineFlag() {
    return sqsDirectOnlineFlag;
  }

  public void setSqsDirectOnlineFlag(Boolean sqsDirectOnlineFlag) {
    this.sqsDirectOnlineFlag = sqsDirectOnlineFlag;
  }

  @JsonIgnore
  public DeviceInfo amqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
    return this;
  }

   /**
   * MI对应的队列在线标志,true：在线 false：不在线
   * @return amqQueueOnlineFlag
  **/


  @ApiModelProperty(value = "MI对应的队列在线标志,true：在线 false：不在线")
  public Boolean AmqQueueOnlineFlag() {
    return amqQueueOnlineFlag;
  }

  public void setAmqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
  }

  @JsonIgnore
  public DeviceInfo amqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
    return this;
  }

   /**
   * 【基于心跳】amq直连在线标志,true:在线 false:不在线
   * @return amqDirectOnlineFlag
  **/


  @ApiModelProperty(value = "【基于心跳】amq直连在线标志,true:在线 false:不在线")
  public Boolean AmqDirectOnlineFlag() {
    return amqDirectOnlineFlag;
  }

  public void setAmqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
  }

  @JsonIgnore
  public DeviceInfo queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 开票设备监听的队列，查询时返回
   * @return queueName
  **/


  @ApiModelProperty(value = "开票设备监听的队列，查询时返回")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public DeviceInfo sqsQueueName(String sqsQueueName) {
    this.sqsQueueName = sqsQueueName;
    return this;
  }

   /**
   * 开票设备SQS监听的队列，查询时返回
   * @return sqsQueueName
  **/


  @ApiModelProperty(value = "开票设备SQS监听的队列，查询时返回")
  public String getSqsQueueName() {
    return sqsQueueName;
  }

  public void setSqsQueueName(String sqsQueueName) {
    this.sqsQueueName = sqsQueueName;
  }

  @JsonIgnore
  public DeviceInfo clientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * 客户端信息
   * @return clientInfo
  **/

  @Valid

  @ApiModelProperty(value = "客户端信息")
  public HeartBeatClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  @JsonIgnore
  public DeviceInfo originAccountQueueName(String originAccountQueueName) {
    this.originAccountQueueName = originAccountQueueName;
    return this;
  }

   /**
   * 底账监听的队列，查询时返回
   * @return originAccountQueueName
  **/


  @ApiModelProperty(value = "底账监听的队列，查询时返回")
  public String getOriginAccountQueueName() {
    return originAccountQueueName;
  }

  public void setOriginAccountQueueName(String originAccountQueueName) {
    this.originAccountQueueName = originAccountQueueName;
  }

  @JsonIgnore
  public DeviceInfo service(List<String> service) {
    this.service = service;
    return this;
  }

  public DeviceInfo addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）（VUKey、elTaxCert设备非必填，系统自动维护）
   * @return service
  **/


  @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）（VUKey、elTaxCert设备非必填，系统自动维护）")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }

  @JsonIgnore
  public DeviceInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：删除）（传入审核通过状态时，系统会将状态自动变更为未启用状态）
   * @return status
  **/


  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：删除）（传入审核通过状态时，系统会将状态自动变更为未启用状态）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public DeviceInfo hasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
    return this;
  }

   /**
   * 是否有授权文件,查询时返回
   * @return hasLicenseFlag
  **/


  @ApiModelProperty(value = "是否有授权文件,查询时返回")
  public Boolean HasLicenseFlag() {
    return hasLicenseFlag;
  }

  public void setHasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
  }

  @JsonIgnore
  public DeviceInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public DeviceInfo elSubscriptionQueues(List<String> elSubscriptionQueues) {
    this.elSubscriptionQueues = elSubscriptionQueues;
    return this;
  }

  public DeviceInfo addElSubscriptionQueuesItem(String elSubscriptionQueuesItem) {
    this.elSubscriptionQueues.add(elSubscriptionQueuesItem);
    return this;
  }

   /**
   * 底账队列,当查询底账订阅队列为true时返回
   * @return elSubscriptionQueues
  **/


  @ApiModelProperty(value = "底账队列,当查询底账订阅队列为true时返回")
  public List<String> getElSubscriptionQueues() {
    return elSubscriptionQueues;
  }

  public void setElSubscriptionQueues(List<String> elSubscriptionQueues) {
    this.elSubscriptionQueues = elSubscriptionQueues;
  }

  @JsonIgnore
  public DeviceInfo extraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
    return this;
  }

   /**
   * 配置信息
   * @return extraInfo
  **/

  @Valid

  @ApiModelProperty(value = "配置信息")
  public DeviceExtraInfo getExtraInfo() {
    return extraInfo;
  }

  public void setExtraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
  }

  @JsonIgnore
  public DeviceInfo taxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "税控设备消息")
  public TaxDeviceInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceInfo deviceInfo = (DeviceInfo) o;
    return Objects.equals(this.id, deviceInfo.id) &&
        Objects.equals(this.deviceUn, deviceInfo.deviceUn) &&
        Objects.equals(this.companyInfo, deviceInfo.companyInfo) &&
        Objects.equals(this.operateInfo, deviceInfo.operateInfo) &&
        Objects.equals(this.deviceNo, deviceInfo.deviceNo) &&
        Objects.equals(this.deviceName, deviceInfo.deviceName) &&
        Objects.equals(this.deviceType, deviceInfo.deviceType) &&
        Objects.equals(this.remark, deviceInfo.remark) &&
        Objects.equals(this.sqsDirectOnlineFlag, deviceInfo.sqsDirectOnlineFlag) &&
        Objects.equals(this.amqQueueOnlineFlag, deviceInfo.amqQueueOnlineFlag) &&
        Objects.equals(this.amqDirectOnlineFlag, deviceInfo.amqDirectOnlineFlag) &&
        Objects.equals(this.queueName, deviceInfo.queueName) &&
        Objects.equals(this.sqsQueueName, deviceInfo.sqsQueueName) &&
        Objects.equals(this.clientInfo, deviceInfo.clientInfo) &&
        Objects.equals(this.originAccountQueueName, deviceInfo.originAccountQueueName) &&
        Objects.equals(this.service, deviceInfo.service) &&
        Objects.equals(this.status, deviceInfo.status) &&
        Objects.equals(this.hasLicenseFlag, deviceInfo.hasLicenseFlag) &&
        Objects.equals(this.fromSystem, deviceInfo.fromSystem) &&
        Objects.equals(this.elSubscriptionQueues, deviceInfo.elSubscriptionQueues) &&
        Objects.equals(this.extraInfo, deviceInfo.extraInfo) &&
        Objects.equals(this.taxDeviceInfo, deviceInfo.taxDeviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deviceUn, companyInfo, operateInfo, deviceNo, deviceName, deviceType, remark, sqsDirectOnlineFlag, amqQueueOnlineFlag, amqDirectOnlineFlag, queueName, sqsQueueName, clientInfo, originAccountQueueName, service, status, hasLicenseFlag, fromSystem, elSubscriptionQueues, extraInfo, taxDeviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    sqsDirectOnlineFlag: ").append(toIndentedString(sqsDirectOnlineFlag)).append("\n");
    sb.append("    amqQueueOnlineFlag: ").append(toIndentedString(amqQueueOnlineFlag)).append("\n");
    sb.append("    amqDirectOnlineFlag: ").append(toIndentedString(amqDirectOnlineFlag)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    sqsQueueName: ").append(toIndentedString(sqsQueueName)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    originAccountQueueName: ").append(toIndentedString(originAccountQueueName)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    hasLicenseFlag: ").append(toIndentedString(hasLicenseFlag)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    elSubscriptionQueues: ").append(toIndentedString(elSubscriptionQueues)).append("\n");
    sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
