package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.SubscribeDeviceStock;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GetSubscribeDeviceStockResponse
 */

@JsonInclude(NON_NULL)
public class GetSubscribeDeviceStockResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("code")
  private String code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("result")
  private SubscribeDeviceStock result = null;

  @JsonIgnore
  public GetSubscribeDeviceStockResponse code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 系统代码
   * @return code
  **/


  @ApiModelProperty(value = "系统代码")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public GetSubscribeDeviceStockResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 信息
   * @return message
  **/


  @ApiModelProperty(value = "信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public GetSubscribeDeviceStockResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GetSubscribeDeviceStockResponse result(SubscribeDeviceStock result) {
    this.result = result;
    return this;
  }

   /**
   * 税盘库存订阅信息
   * @return result
  **/

  @Valid

  @ApiModelProperty(value = "税盘库存订阅信息")
  public SubscribeDeviceStock getResult() {
    return result;
  }

  public void setResult(SubscribeDeviceStock result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSubscribeDeviceStockResponse getSubscribeDeviceStockResponse = (GetSubscribeDeviceStockResponse) o;
    return Objects.equals(this.code, getSubscribeDeviceStockResponse.code) &&
        Objects.equals(this.message, getSubscribeDeviceStockResponse.message) &&
        Objects.equals(this.head, getSubscribeDeviceStockResponse.head) &&
        Objects.equals(this.result, getSubscribeDeviceStockResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, head, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSubscribeDeviceStockResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
