package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ClientInvoiceStockInfo;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.ServerInvoiceStockInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceStockResponse
 */

@JsonInclude(NON_NULL)
public class InvoiceStockResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("clientInvoiceStockInfoList")
  private List<ClientInvoiceStockInfo> clientInvoiceStockInfoList = new ArrayList<>();

  @JsonProperty("serverInvoiceStockInfoList")
  private List<ServerInvoiceStockInfo> serverInvoiceStockInfoList = new ArrayList<>();

  @JsonIgnore
  public InvoiceStockResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceStockResponse clientInvoiceStockInfoList(List<ClientInvoiceStockInfo> clientInvoiceStockInfoList) {
    this.clientInvoiceStockInfoList = clientInvoiceStockInfoList;
    return this;
  }

  public InvoiceStockResponse addClientInvoiceStockInfoListItem(ClientInvoiceStockInfo clientInvoiceStockInfoListItem) {
    this.clientInvoiceStockInfoList.add(clientInvoiceStockInfoListItem);
    return this;
  }

   /**
   * 客户端库存信息
   * @return clientInvoiceStockInfoList
  **/

  @Valid

  @ApiModelProperty(value = "客户端库存信息")
  public List<ClientInvoiceStockInfo> getClientInvoiceStockInfoList() {
    return clientInvoiceStockInfoList;
  }

  public void setClientInvoiceStockInfoList(List<ClientInvoiceStockInfo> clientInvoiceStockInfoList) {
    this.clientInvoiceStockInfoList = clientInvoiceStockInfoList;
  }

  @JsonIgnore
  public InvoiceStockResponse serverInvoiceStockInfoList(List<ServerInvoiceStockInfo> serverInvoiceStockInfoList) {
    this.serverInvoiceStockInfoList = serverInvoiceStockInfoList;
    return this;
  }

  public InvoiceStockResponse addServerInvoiceStockInfoListItem(ServerInvoiceStockInfo serverInvoiceStockInfoListItem) {
    this.serverInvoiceStockInfoList.add(serverInvoiceStockInfoListItem);
    return this;
  }

   /**
   * 服务器端库存信息
   * @return serverInvoiceStockInfoList
  **/

  @Valid

  @ApiModelProperty(value = "服务器端库存信息")
  public List<ServerInvoiceStockInfo> getServerInvoiceStockInfoList() {
    return serverInvoiceStockInfoList;
  }

  public void setServerInvoiceStockInfoList(List<ServerInvoiceStockInfo> serverInvoiceStockInfoList) {
    this.serverInvoiceStockInfoList = serverInvoiceStockInfoList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceStockResponse invoiceStockResponse = (InvoiceStockResponse) o;
    return Objects.equals(this.head, invoiceStockResponse.head) &&
        Objects.equals(this.clientInvoiceStockInfoList, invoiceStockResponse.clientInvoiceStockInfoList) &&
        Objects.equals(this.serverInvoiceStockInfoList, invoiceStockResponse.serverInvoiceStockInfoList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, clientInvoiceStockInfoList, serverInvoiceStockInfoList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceStockResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    clientInvoiceStockInfoList: ").append(toIndentedString(clientInvoiceStockInfoList)).append("\n");
    sb.append("    serverInvoiceStockInfoList: ").append(toIndentedString(serverInvoiceStockInfoList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
