package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端授权信息
 */
@ApiModel(description = "终端授权信息")

@JsonInclude(NON_NULL)
public class LicenseInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("expireAt")
  private String expireAt = null;

  @JsonProperty("synGenerateFlag")
  private Boolean synGenerateFlag = false;

  @JsonIgnore
  public LicenseInfo expireAt(String expireAt) {
    this.expireAt = expireAt;
    return this;
  }

   /**
   * 授权文件到期日期(yyyy/MM/dd)
   * @return expireAt
  **/


  @ApiModelProperty(value = "授权文件到期日期(yyyy/MM/dd)")
  public String getExpireAt() {
    return expireAt;
  }

  public void setExpireAt(String expireAt) {
    this.expireAt = expireAt;
  }

  @JsonIgnore
  public LicenseInfo synGenerateFlag(Boolean synGenerateFlag) {
    this.synGenerateFlag = synGenerateFlag;
    return this;
  }

   /**
   * 同步成生授权文件标志(仅新增终端时有效)
   * @return synGenerateFlag
  **/


  @ApiModelProperty(value = "同步成生授权文件标志(仅新增终端时有效)")
  public Boolean SynGenerateFlag() {
    return synGenerateFlag;
  }

  public void setSynGenerateFlag(Boolean synGenerateFlag) {
    this.synGenerateFlag = synGenerateFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseInfo licenseInfo = (LicenseInfo) o;
    return Objects.equals(this.expireAt, licenseInfo.expireAt) &&
        Objects.equals(this.synGenerateFlag, licenseInfo.synGenerateFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expireAt, synGenerateFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LicenseInfo {\n");
    
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    synGenerateFlag: ").append(toIndentedString(synGenerateFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
