package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.Config;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryConfigResponse
 */

@JsonInclude(NON_NULL)
public class QueryConfigResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("globalConfig")
  private List<Config> globalConfig = new ArrayList<>();

  @JsonProperty("customConfig")
  private List<Config> customConfig = new ArrayList<>();

  @JsonIgnore
  public QueryConfigResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询配置信息响应，客户端调用时subCode=119 表示加密校验失败
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询配置信息响应，客户端调用时subCode=119 表示加密校验失败")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryConfigResponse globalConfig(List<Config> globalConfig) {
    this.globalConfig = globalConfig;
    return this;
  }

  public QueryConfigResponse addGlobalConfigItem(Config globalConfigItem) {
    this.globalConfig.add(globalConfigItem);
    return this;
  }

   /**
   * 全局配置
   * @return globalConfig
  **/

  @Valid

  @ApiModelProperty(value = "全局配置")
  public List<Config> getGlobalConfig() {
    return globalConfig;
  }

  public void setGlobalConfig(List<Config> globalConfig) {
    this.globalConfig = globalConfig;
  }

  @JsonIgnore
  public QueryConfigResponse customConfig(List<Config> customConfig) {
    this.customConfig = customConfig;
    return this;
  }

  public QueryConfigResponse addCustomConfigItem(Config customConfigItem) {
    this.customConfig.add(customConfigItem);
    return this;
  }

   /**
   * 自定义配置
   * @return customConfig
  **/

  @Valid

  @ApiModelProperty(value = "自定义配置")
  public List<Config> getCustomConfig() {
    return customConfig;
  }

  public void setCustomConfig(List<Config> customConfig) {
    this.customConfig = customConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryConfigResponse queryConfigResponse = (QueryConfigResponse) o;
    return Objects.equals(this.head, queryConfigResponse.head) &&
        Objects.equals(this.globalConfig, queryConfigResponse.globalConfig) &&
        Objects.equals(this.customConfig, queryConfigResponse.customConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, globalConfig, customConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryConfigResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    globalConfig: ").append(toIndentedString(globalConfig)).append("\n");
    sb.append("    customConfig: ").append(toIndentedString(customConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
