package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.DeviceQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceSortInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryDeviceRequest
 */

@JsonInclude(NON_NULL)
public class QueryDeviceRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("queryInfo")
  private DeviceQueryInfo queryInfo = null;

  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  @JsonProperty("sortInfo")
  private DeviceSortInfo sortInfo = null;

  @JsonProperty("queryServiceState")
  private Boolean queryServiceState = null;

  @JsonProperty("queryOriginAccountServiceState")
  private Boolean queryOriginAccountServiceState = false;

  @JsonProperty("queryELSubscriptionQueue")
  private Boolean queryELSubscriptionQueue = false;

  @JsonIgnore
  public QueryDeviceRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryDeviceRequest queryInfo(DeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
    return this;
  }

   /**
   * （必填）查询信息
   * @return queryInfo
  **/

  @Valid

  @ApiModelProperty(value = "（必填）查询信息")
  public DeviceQueryInfo getQueryInfo() {
    return queryInfo;
  }

  public void setQueryInfo(DeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
  }

  @JsonIgnore
  public QueryDeviceRequest pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  @JsonIgnore
  public QueryDeviceRequest sortInfo(DeviceSortInfo sortInfo) {
    this.sortInfo = sortInfo;
    return this;
  }

   /**
   * 排序信息
   * @return sortInfo
  **/

  @Valid

  @ApiModelProperty(value = "排序信息")
  public DeviceSortInfo getSortInfo() {
    return sortInfo;
  }

  public void setSortInfo(DeviceSortInfo sortInfo) {
    this.sortInfo = sortInfo;
  }

  @JsonIgnore
  public QueryDeviceRequest queryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
    return this;
  }

   /**
   * 查询直连在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）
   * @return queryServiceState
  **/


  @ApiModelProperty(value = "查询直连在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）")
  public Boolean QueryServiceState() {
    return queryServiceState;
  }

  public void setQueryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
  }

  @JsonIgnore
  public QueryDeviceRequest queryOriginAccountServiceState(Boolean queryOriginAccountServiceState) {
    this.queryOriginAccountServiceState = queryOriginAccountServiceState;
    return this;
  }

   /**
   * 查询底账在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）
   * @return queryOriginAccountServiceState
  **/


  @ApiModelProperty(value = "查询底账在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）")
  public Boolean QueryOriginAccountServiceState() {
    return queryOriginAccountServiceState;
  }

  public void setQueryOriginAccountServiceState(Boolean queryOriginAccountServiceState) {
    this.queryOriginAccountServiceState = queryOriginAccountServiceState;
  }

  @JsonIgnore
  public QueryDeviceRequest queryELSubscriptionQueue(Boolean queryELSubscriptionQueue) {
    this.queryELSubscriptionQueue = queryELSubscriptionQueue;
    return this;
  }

   /**
   * 查询底账订阅队列,true：查询 false：不查询
   * @return queryELSubscriptionQueue
  **/


  @ApiModelProperty(value = "查询底账订阅队列,true：查询 false：不查询")
  public Boolean QueryELSubscriptionQueue() {
    return queryELSubscriptionQueue;
  }

  public void setQueryELSubscriptionQueue(Boolean queryELSubscriptionQueue) {
    this.queryELSubscriptionQueue = queryELSubscriptionQueue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryDeviceRequest queryDeviceRequest = (QueryDeviceRequest) o;
    return Objects.equals(this.head, queryDeviceRequest.head) &&
        Objects.equals(this.queryInfo, queryDeviceRequest.queryInfo) &&
        Objects.equals(this.pageInfo, queryDeviceRequest.pageInfo) &&
        Objects.equals(this.sortInfo, queryDeviceRequest.sortInfo) &&
        Objects.equals(this.queryServiceState, queryDeviceRequest.queryServiceState) &&
        Objects.equals(this.queryOriginAccountServiceState, queryDeviceRequest.queryOriginAccountServiceState) &&
        Objects.equals(this.queryELSubscriptionQueue, queryDeviceRequest.queryELSubscriptionQueue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queryInfo, pageInfo, sortInfo, queryServiceState, queryOriginAccountServiceState, queryELSubscriptionQueue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryDeviceRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queryInfo: ").append(toIndentedString(queryInfo)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
    sb.append("    queryServiceState: ").append(toIndentedString(queryServiceState)).append("\n");
    sb.append("    queryOriginAccountServiceState: ").append(toIndentedString(queryOriginAccountServiceState)).append("\n");
    sb.append("    queryELSubscriptionQueue: ").append(toIndentedString(queryELSubscriptionQueue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
